/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.bool;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.impl.scheduler.BoolEvtScheduler;
import org.chocosolver.solver.variables.impl.siglit.SignedLiteral;
import org.chocosolver.solver.variables.view.IntView;
import org.chocosolver.solver.variables.view.ViewDeltaMonitor;
import org.chocosolver.util.ESat;
import org.chocosolver.util.iterators.EvtScheduler;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSet;

public final class BoolNotView<B extends BoolVar>
extends IntView<B>
implements BoolVar {
    public BoolNotView(B var) {
        super("not(" + var.getName() + ")", var);
    }

    @Override
    public ESat getBooleanValue() {
        return ESat.not(((BoolVar)this.var).getBooleanValue());
    }

    @Override
    public boolean setToTrue(ICause cause) throws ContradictionException {
        return this.instantiateTo(1, cause);
    }

    @Override
    public boolean setToFalse(ICause cause) throws ContradictionException {
        return this.instantiateTo(0, cause);
    }

    @Override
    public boolean removeValue(int value, ICause cause) throws ContradictionException {
        return this.contains(value) && this.instantiateTo(1 - value, cause);
    }

    @Override
    public boolean removeValues(IntIterableSet values, ICause cause) throws ContradictionException {
        boolean hasChanged = false;
        if (values.contains(0)) {
            hasChanged = this.instantiateTo(1, cause);
        }
        if (values.contains(1)) {
            hasChanged = this.instantiateTo(0, cause);
        }
        return hasChanged;
    }

    @Override
    public boolean removeAllValuesBut(IntIterableSet values, ICause cause) throws ContradictionException {
        boolean hasChanged = false;
        if (!values.contains(0)) {
            hasChanged = this.instantiateTo(1, cause);
        }
        if (!values.contains(1)) {
            hasChanged = this.instantiateTo(0, cause);
        }
        return hasChanged;
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        boolean hasChanged = false;
        if (from <= to && from <= 1 && to >= 0) {
            if (from == 1) {
                hasChanged = this.instantiateTo(1, cause);
            } else if (to == 0) {
                hasChanged = this.instantiateTo(0, cause);
            } else {
                this.instantiateTo(2, cause);
            }
        }
        return hasChanged;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        if (!this.contains(value)) {
            this.model.getSolver().getEventObserver().instantiateTo(this, value, cause, this.getLB(), this.getUB());
            this.contradiction(cause, "the variable is already instantiated to another value");
        } else if (!this.isInstantiated()) {
            this.model.getSolver().getEventObserver().instantiateTo(this, value, cause, this.getLB(), this.getUB());
            boolean done = ((BoolVar)this.var).instantiateTo(1 - value, this);
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return done;
        }
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        return value > 0 && this.instantiateTo(value, cause);
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        return value < 1 && this.instantiateTo(value, cause);
    }

    @Override
    public boolean updateBounds(int lb, int ub, ICause cause) throws ContradictionException {
        boolean hasChanged = false;
        if (lb > 1) {
            ((BoolVar)this.var).instantiateTo(-1, cause);
        } else if (ub < 0) {
            ((BoolVar)this.var).instantiateTo(2, cause);
        } else if (lb == 1) {
            hasChanged = this.instantiateTo(1, cause);
        } else if (ub == 0) {
            hasChanged = this.instantiateTo(0, cause);
        }
        return hasChanged;
    }

    @Override
    public boolean contains(int value) {
        return ((BoolVar)this.var).contains(1 - value);
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return ((BoolVar)this.var).isInstantiatedTo(1 - value);
    }

    @Override
    public int getValue() {
        int v = ((BoolVar)this.var).getValue();
        return 1 - v;
    }

    @Override
    public int getLB() {
        if (((BoolVar)this.var).isInstantiated()) {
            return this.getValue();
        }
        return 0;
    }

    @Override
    public int getUB() {
        if (((BoolVar)this.var).isInstantiated()) {
            return this.getValue();
        }
        return 1;
    }

    @Override
    public int nextValue(int v) {
        if (v < 0 && this.contains(0)) {
            return 0;
        }
        return v <= 0 && this.contains(1) ? 1 : Integer.MAX_VALUE;
    }

    @Override
    public int nextValueOut(int v) {
        int lb = 0;
        int ub = 1;
        if (((BoolVar)this.var).isInstantiated()) {
            lb = ub = this.getValue();
        }
        if (lb - 1 <= v && v <= ub) {
            return ub + 1;
        }
        return v + 1;
    }

    @Override
    public int previousValue(int v) {
        if (v > 1 && this.contains(1)) {
            return 1;
        }
        return v >= 1 && this.contains(0) ? 0 : Integer.MIN_VALUE;
    }

    @Override
    public int previousValueOut(int v) {
        int lb = 0;
        int ub = 1;
        if (((BoolVar)this.var).isInstantiated()) {
            lb = ub = this.getValue();
        }
        if (lb <= v && v <= ub + 1) {
            return lb - 1;
        }
        return v - 1;
    }

    @Override
    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        ((BoolVar)this.var).createDelta();
        if (((BoolVar)this.var).getDelta() == NoDelta.singleton) {
            return IIntDeltaMonitor.Default.NONE;
        }
        return new ViewDeltaMonitor(((BoolVar)this.var).monitorDelta(propagator)){

            @Override
            protected int transform(int value) {
                return 1 - value;
            }
        };
    }

    protected EvtScheduler createScheduler() {
        return new BoolEvtScheduler();
    }

    @Override
    public String toString() {
        return "not(" + this.var + ")";
    }

    @Override
    public BoolVar not() {
        return (BoolVar)this.var;
    }

    @Override
    public void _setNot(BoolVar not) {
        assert (not == this.var);
    }

    @Override
    public boolean hasNot() {
        return true;
    }

    @Override
    public boolean isLit() {
        return true;
    }

    @Override
    public boolean isNot() {
        return !((BoolVar)this.var).isNot();
    }

    @Override
    public void setNot(boolean isNot) {
        assert (isNot);
    }

    @Override
    public int getTypeAndKind() {
        return 28;
    }

    @Override
    public void justifyEvent(IntEventType mask, int one, int two, int three) {
        assert (mask == IntEventType.INSTANTIATE);
        this.model.getSolver().getEventObserver().instantiateTo(this, 1 - one, this, 0, 1);
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        IntVar pivot = explanation.readVar(p);
        if (this == pivot) {
            this.intersectLit(this.getValue(), explanation);
            ((BoolVar)this.var).unionLit(this.getValue(), explanation);
        } else {
            this.unionLit(1 - this.getValue(), explanation);
            ((BoolVar)this.var).intersectLit(1 - this.getValue(), explanation);
        }
    }

    @Override
    public void createLit(IntIterableRangeSet rootDomain) {
        if (this.literal != null) {
            throw new IllegalStateException("createLit(Implications) called twice");
        }
        this.literal = new SignedLiteral.Boolean();
    }

    @Override
    public SignedLiteral getLit() {
        if (this.literal == null) {
            throw new NullPointerException("getLit() called on null, a call to createLit(Implications) is required");
        }
        return this.literal;
    }
}

