/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.move;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.loop.move.MoveBinaryDFS;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.DecisionPath;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;

public class MoveBinaryLDS
extends MoveBinaryDFS {
    protected IStateInt dis;
    protected int DIS;

    public MoveBinaryLDS(AbstractStrategy strategy, int discrepancy, IEnvironment environment) {
        super(strategy);
        this.dis = environment.makeInt(0);
        this.DIS = discrepancy;
    }

    @Override
    public boolean init() {
        this.dis.set(0);
        return super.init();
    }

    @Override
    public boolean repair(Solver solver) {
        solver.getMeasures().incBackTrackCount();
        solver.getEnvironment().worldPop();
        boolean repaired = this.rewind(solver);
        Decision head = solver.getDecisionPath().getLastDecision();
        if (head.getPosition() == this.topDecisionPosition && this.dis.get() < this.DIS) {
            this.dis.add(1);
            solver.restart();
            repaired = true;
        }
        return repaired;
    }

    @Override
    protected boolean rewind(Solver solver) {
        boolean repaired = false;
        DecisionPath path = solver.getDecisionPath();
        Decision head = path.getLastDecision();
        while (!repaired && head.getPosition() != this.topDecisionPosition) {
            solver.setJumpTo(solver.getJumpTo() - 1);
            if (this.dis.get() > 0 && solver.getJumpTo() <= 0 && head.hasNext()) {
                solver.getEnvironment().worldPush();
                repaired = true;
                this.dis.add(-1);
            } else {
                this.prevDecision(solver);
            }
            head = solver.getDecisionPath().getLastDecision();
        }
        return repaired;
    }
}

