/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.grid.regular.square;

import java.util.HashMap;
import java.util.Map;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.restopt.choco.ConnectivityFinderSpatialGraph;
import org.restopt.exception.RestoptException;
import org.restopt.grid.regular.square.PartialRegularSquareGrid;

public class PartialRegularGroupedGrid
extends PartialRegularSquareGrid {
    private final int[] sizeCells;
    private final int nbGroups;
    private final ISet[] groups;
    private final ISet[] groupBorders;
    private final int nbGroupedCells;
    private final int[] unGroupedId;
    private final Map<Integer, Integer> gridIdToGroupedId;

    public PartialRegularGroupedGrid(int nbRows, int nbCols, int[] toDiscard, UndirectedGraph groupGraph) {
        this(nbRows, nbCols, toDiscard, groupGraph, 4);
    }

    public PartialRegularGroupedGrid(int nbRows, int nbCols, int[] toDiscard, UndirectedGraph groupGraph, int maxNeighCard) {
        super(nbRows, nbCols, toDiscard);
        int cc;
        this.nbGroupedCells = groupGraph.getNodes().size();
        ConnectivityFinderSpatialGraph connectivityFinder = new ConnectivityFinderSpatialGraph(groupGraph);
        connectivityFinder.findAllCC();
        this.nbGroups = connectivityFinder.getNBCC();
        this.sizeCells = new int[super.getNbCells() - this.nbGroupedCells + this.nbGroups];
        this.groups = new ISet[this.nbGroups];
        this.groupBorders = new ISet[this.nbGroups];
        for (cc = 0; cc < this.nbGroups; ++cc) {
            int sizeCC;
            this.sizeCells[cc] = sizeCC = connectivityFinder.getSizeCC()[cc];
            int[] g = connectivityFinder.getCC(cc);
            this.groupBorders[cc] = SetFactory.makeRangeSet();
            for (int i = 0; i < sizeCC; ++i) {
                if (groupGraph.getNeighborsOf(g[i]).size() < maxNeighCard) {
                    this.groupBorders[cc].add(this.getPartialIndex(g[i]));
                }
                g[i] = this.getPartialIndex(g[i]);
            }
            this.groups[cc] = SetFactory.makeConstantSet(g);
        }
        this.gridIdToGroupedId = new HashMap<Integer, Integer>();
        for (cc = 0; cc < this.nbGroups; ++cc) {
            ISetIterator sizeCC = this.groups[cc].iterator();
            while (sizeCC.hasNext()) {
                int i = (Integer)sizeCC.next();
                this.gridIdToGroupedId.put(i, cc);
            }
        }
        this.unGroupedId = new int[this.getNbCells() - this.nbGroups];
        int nbNotGrouped = 0;
        for (int i = 0; i < super.getNbCells(); ++i) {
            if (this.gridIdToGroupedId.containsKey(i)) continue;
            this.gridIdToGroupedId.put(i, nbNotGrouped + this.nbGroups);
            this.unGroupedId[nbNotGrouped] = i;
            this.sizeCells[nbNotGrouped + this.nbGroups] = 1;
            ++nbNotGrouped;
        }
    }

    @Override
    public int getNbCells() {
        return super.getNbCells() - this.nbGroupedCells + this.nbGroups;
    }

    public int getNbUngroupedCells() {
        return super.getNbCells();
    }

    public ISet getGroup(int groupId) {
        return this.groups[groupId];
    }

    public ISet getGroupBorders(int group) {
        return this.groupBorders[group];
    }

    public int[] getSizeCells() {
        return this.sizeCells;
    }

    public int getNbGroups() {
        return this.nbGroups;
    }

    public int getUngroupedPartialIndex(int groupedIdx) {
        if (groupedIdx < this.nbGroups) {
            throw new RuntimeException("A grouped cell is not associated to a complete index");
        }
        return this.unGroupedId[groupedIdx - this.nbGroups];
    }

    public int getUngroupedCompleteIndex(int groupedIdx) {
        if (groupedIdx < this.nbGroups) {
            throw new RuntimeException("A grouped cell is not associated to a complete index");
        }
        return this.getCompleteIndex(this.unGroupedId[groupedIdx - this.nbGroups]);
    }

    public int getGroupIndexFromCompleteIndex(int completeIndex) {
        int partialIndex = this.getPartialIndex(completeIndex);
        return this.gridIdToGroupedId.get(partialIndex);
    }

    public int getGroupIndexFromPartialIndex(int partialIndex) {
        return this.gridIdToGroupedId.get(partialIndex);
    }

    @Override
    public double[][] getCartesianCoordinates() {
        double[][] coords = new double[super.getNbCells()][];
        for (int i = 0; i < super.getNbCells(); ++i) {
            int[] coord = super.getCoordinatesFromIndex(i);
            coords[i] = new double[]{coord[1], coord[0]};
        }
        return coords;
    }

    @Override
    public double[] getCartesianCoordinates(int partialGroupedIndex) throws RestoptException {
        if (partialGroupedIndex < this.getNbGroups()) {
            throw new RestoptException("Cannot associate cartesian coordinates to a grouped cell");
        }
        int[] c = super.getCoordinatesFromIndex(this.getUngroupedPartialIndex(partialGroupedIndex));
        return new double[]{c[1], c[0]};
    }

    public double[] getCartesianCoordinatesFromPartialIndex(int partialIndex) {
        int[] c = super.getCoordinatesFromIndex(partialIndex);
        return new double[]{c[1], c[0]};
    }
}

