/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.restart.AbstractRestart;
import org.chocosolver.solver.search.restart.GeometricalCutoff;
import org.chocosolver.solver.search.restart.InnerOuterCutoff;
import org.chocosolver.solver.search.restart.LinearCutoff;
import org.chocosolver.solver.search.restart.LubyCutoff;
import org.chocosolver.solver.search.restart.Restarter;
import org.chocosolver.solver.search.strategy.Search;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainBest;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainLast;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainMax;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainMedian;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainMiddle;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainMin;
import org.chocosolver.solver.search.strategy.selectors.values.IntDomainRandom;
import org.chocosolver.solver.search.strategy.selectors.values.IntValueSelector;
import org.chocosolver.solver.search.strategy.selectors.variables.ActivityBased;
import org.chocosolver.solver.search.strategy.selectors.variables.ConflictHistorySearch;
import org.chocosolver.solver.search.strategy.selectors.variables.DomOverWDeg;
import org.chocosolver.solver.search.strategy.selectors.variables.DomOverWDegRef;
import org.chocosolver.solver.search.strategy.selectors.variables.FailureBased;
import org.chocosolver.solver.search.strategy.selectors.variables.FirstFail;
import org.chocosolver.solver.search.strategy.selectors.variables.InputOrder;
import org.chocosolver.solver.search.strategy.selectors.variables.PickOnDom;
import org.chocosolver.solver.search.strategy.selectors.variables.PickOnFil;
import org.chocosolver.solver.search.strategy.selectors.variables.Random;
import org.chocosolver.solver.search.strategy.selectors.variables.VariableSelector;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.tools.TimeUtils;

public interface SearchParams {

    public static class ValSelConf {
        final ValueSelection valsel;
        final boolean best;
        final int bestFreq;
        final boolean last;

        public ValSelConf(ValueSelection valH, boolean best, int bestFreq, boolean last) {
            this.valsel = valH;
            this.best = best;
            this.bestFreq = bestFreq;
            this.last = last;
        }

        public Function<Model, IntValueSelector> make() {
            Function<Model, IntValueSelector> fn0;
            switch (this.valsel.ordinal()) {
                default: {
                    fn0 = m -> new IntDomainMin();
                    break;
                }
                case 1: {
                    fn0 = m -> new IntDomainMax();
                    break;
                }
                case 2: {
                    fn0 = m -> new IntDomainMedian();
                    break;
                }
                case 4: {
                    fn0 = m -> new IntDomainMiddle(false);
                    break;
                }
                case 3: {
                    fn0 = m -> new IntDomainMiddle(true);
                    break;
                }
                case 5: {
                    fn0 = m -> new IntDomainRandom(m.getSeed());
                }
            }
            Function<Model, IntValueSelector> fn1 = this.best ? m -> new IntDomainBest((IntValueSelector)fn0.apply((Model)m), v -> m.getSolver().getRestartCount() % (long)this.bestFreq == 0L) : fn0;
            Function<Model, IntValueSelector> fn2 = this.last ? m -> {
                m.getSolver().attach(m.getSolver().defaultSolution());
                return new IntDomainLast(m.getSolver().defaultSolution(), (IntValueSelector)fn1.apply((Model)m), null);
            } : fn1;
            return fn2;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ValSelConf) {
                ValSelConf vsc = (ValSelConf)obj;
                return this.valsel == vsc.valsel && this.best == vsc.best && this.bestFreq == vsc.bestFreq && this.last == vsc.last;
            }
            return false;
        }
    }

    public static class VarSelConf {
        final VariableSelection varsel;
        final int flushRate;

        public VarSelConf(VariableSelection varsel, int flushRate) {
            this.varsel = varsel;
            this.flushRate = flushRate;
        }

        public BiFunction<IntVar[], IntValueSelector, AbstractStrategy<IntVar>> make() {
            switch (this.varsel.ordinal()) {
                case 0: {
                    return (vars, vsel) -> new ActivityBased(vars[0].getModel(), (IntVar[])vars, (IntValueSelector)vsel, 0.999, 0.2, 8, 1, 0L);
                }
                case 1: {
                    return (vars, vsel) -> Search.intVarSearch((VariableSelector<IntVar>)new ConflictHistorySearch((Variable[])vars, 0L, this.flushRate), vsel, vars);
                }
                case 2: 
                case 3: {
                    return (vars, vsel) -> Search.intVarSearch((VariableSelector<IntVar>)new FirstFail(vars[0].getModel()), vsel, vars);
                }
                case 5: {
                    return (vars, vsel) -> Search.intVarSearch((VariableSelector<IntVar>)new DomOverWDegRef((Variable[])vars, 0L, this.flushRate), vsel, vars);
                }
                case 6: {
                    return (vars, vsel) -> Search.intVarSearch((VariableSelector<IntVar>)new FailureBased((Variable[])vars, 0L, 4), vsel, vars);
                }
                case 7: {
                    return (vars, vsel) -> Search.intVarSearch((VariableSelector<IntVar>)new FailureBased((Variable[])vars, 0L, 2), vsel, vars);
                }
                case 8: {
                    return (vars, vsel) -> Search.intVarSearch(new InputOrder<IntVar>(vars[0].getModel()), vsel, vars);
                }
                case 9: {
                    return (vars, vsel) -> Search.intVarSearch((VariableSelector<IntVar>)new PickOnDom((Variable[])vars, 0, this.flushRate), vsel, vars);
                }
                case 10: {
                    return (vars, vsel) -> Search.intVarSearch((VariableSelector<IntVar>)new PickOnDom((Variable[])vars, 1, this.flushRate), vsel, vars);
                }
                case 11: {
                    return (vars, vsel) -> Search.intVarSearch((VariableSelector<IntVar>)new PickOnDom((Variable[])vars, 2, this.flushRate), vsel, vars);
                }
                case 12: {
                    return (vars, vsel) -> Search.intVarSearch((VariableSelector<IntVar>)new PickOnDom((Variable[])vars, 3, this.flushRate), vsel, vars);
                }
                case 13: {
                    return (vars, vsel) -> Search.intVarSearch((VariableSelector<IntVar>)new PickOnFil((Variable[])vars, 0, this.flushRate), vsel, vars);
                }
                case 14: {
                    return (vars, vsel) -> Search.intVarSearch((VariableSelector<IntVar>)new PickOnFil((Variable[])vars, 1, this.flushRate), vsel, vars);
                }
                case 15: {
                    return (vars, vsel) -> Search.intVarSearch((VariableSelector<IntVar>)new PickOnFil((Variable[])vars, 2, this.flushRate), vsel, vars);
                }
                case 16: {
                    return (vars, vsel) -> Search.intVarSearch((VariableSelector<IntVar>)new PickOnFil((Variable[])vars, 3, this.flushRate), vsel, vars);
                }
                case 18: {
                    return (vars, vsel) -> Search.roundRobinSearch(vars);
                }
                case 17: {
                    return (vars, vsel) -> Search.intVarSearch(new Random<IntVar>(vars[0].getModel().getSeed()), vsel, vars);
                }
            }
            return (vars, vsel) -> Search.intVarSearch((VariableSelector<IntVar>)new DomOverWDeg((Variable[])vars, 0L, this.flushRate), vsel, vars);
        }

        public boolean equals(Object obj) {
            if (obj instanceof VarSelConf) {
                VarSelConf other = (VarSelConf)obj;
                return this.varsel == other.varsel && this.flushRate == other.flushRate;
            }
            return false;
        }
    }

    public static class LimConf {
        final long time;
        final int sols;
        final int runs;

        public LimConf(long timeInMS, int sols, int runs) {
            this.time = timeInMS;
            this.sols = sols;
            this.runs = runs;
        }

        public LimConf(String duration, int sols, int runs) {
            this.time = TimeUtils.convertInMilliseconds(duration);
            this.sols = sols;
            this.runs = runs;
        }

        public long getTime() {
            return this.time;
        }

        public int getSols() {
            return this.sols;
        }

        public int getRuns() {
            return this.runs;
        }

        public String toString() {
            return "[" + (float)this.time / 1000.0f + "s, " + this.runs + "runs, " + this.sols + "sols]";
        }
    }

    public static class ResConf {
        final Restart pol;
        final int cutoff;
        final int offset;
        final double geo;
        final boolean resetOnSolution;

        public ResConf(Restart pol, int cutoff, double geo, int offset, boolean resetOnSolution) {
            this.pol = pol;
            this.cutoff = cutoff;
            this.offset = offset;
            this.geo = geo;
            this.resetOnSolution = resetOnSolution;
        }

        public ResConf(Restart pol, int cutoff, int offset, boolean resetOnSolution) {
            this(pol, cutoff, 1.05, offset, resetOnSolution);
        }

        public Function<Solver, AbstractRestart> make() {
            switch (this.pol.ordinal()) {
                default: {
                    return s -> AbstractRestart.NO_RESTART;
                }
                case 1: {
                    return s -> new Restarter(new LubyCutoff(this.cutoff), c -> s.getFailCount() >= c, this.offset, this.resetOnSolution);
                }
                case 2: {
                    return s -> new Restarter(new GeometricalCutoff(this.cutoff, this.geo), c -> s.getFailCount() >= c, this.offset, this.resetOnSolution);
                }
                case 3: {
                    return s -> new Restarter(new InnerOuterCutoff(this.cutoff, this.geo, this.geo), c -> s.getFailCount() >= c, this.offset, this.resetOnSolution);
                }
                case 4: 
            }
            return s -> new Restarter(new LinearCutoff(this.cutoff), c -> s.getFailCount() >= c, this.offset, this.resetOnSolution);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ResConf) {
                ResConf other = (ResConf)obj;
                return this.pol == other.pol && this.cutoff == other.cutoff && this.offset == other.offset && this.geo == other.geo && this.resetOnSolution == other.resetOnSolution;
            }
            return false;
        }

        public String toString() {
            return "[" + (Object)((Object)this.pol) + "," + this.cutoff + "," + this.geo + "," + this.offset + "," + this.resetOnSolution + ']';
        }
    }

    public static enum ValueSelection {
        MIN,
        MAX,
        MED,
        MIDFLOOR,
        MIDCEIL,
        RAND;

    }

    public static enum VariableTieBreaker {
        LEX,
        SMALLEST_DOMAIN,
        LARGEST_DOMAIN,
        SMALLEST_VALUE,
        LARGEST_VALUE;

    }

    public static enum VariableSelection {
        ACTIVITY,
        CHS,
        DOM,
        FIRST_FAIL,
        DOMWDEG,
        DOMWDEG_CACD,
        FLBA,
        FRBA,
        INPUT,
        PICKONDOM0,
        PICKONDOM1,
        PICKONDOM2,
        PICKONDOM3,
        PICKONFIL0,
        PICKONFIL1,
        PICKONFIL2,
        PICKONFIL3,
        RAND,
        ROUND_ROBIN;

    }

    public static enum Restart {
        NONE,
        LUBY,
        GEOMETRIC,
        INNER_OUTER,
        ARITHMETIC;

    }
}

