/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.constraints;

import org.restopt.RestoptProblem;
import org.restopt.constraints.CompactnessConstraint;
import org.restopt.constraints.EffectiveMeshSizeConstraint;
import org.restopt.constraints.IntegralIndexOfConnectivityConstraint;
import org.restopt.constraints.NbComponentsConstraint;
import org.restopt.constraints.NbPatchesConstraint;
import org.restopt.constraints.NoNewPatchConstraint;
import org.restopt.constraints.RestorableAreaConstraint;
import org.restopt.exception.RestoptException;

public interface IRestoptConstraintFactory {
    public RestoptProblem self();

    default public void postNbComponentsConstraint(int minNbCC, int maxNbCC) {
        new NbComponentsConstraint(this.self(), minNbCC, maxNbCC).post();
    }

    default public void postNbPatchesConstraint(int minNP, int maxNP) {
        new NbPatchesConstraint(this.self(), minNP, maxNP).post();
    }

    default public void postCompactnessConstraint(double maxDiameter) {
        new CompactnessConstraint(this.self(), maxDiameter).post();
    }

    default public void postCompactnessConstraint(double minDiameter, double maxDiameter) {
        new CompactnessConstraint(this.self(), minDiameter, maxDiameter).post();
    }

    default public void postRestorableConstraint(int minAreaToRestore, int maxAreaToRestore, double minProportion) throws RestoptException {
        new RestorableAreaConstraint(this.self(), minAreaToRestore, maxAreaToRestore, minProportion).post();
    }

    default public void postMinMeshConstraint(double minMesh, int precision) throws RestoptException {
        new EffectiveMeshSizeConstraint(this.self(), minMesh, this.self().getLandscapeArea(), precision).post();
    }

    default public void postMinIICConstraint(double minIIC, int distanceThreshold, int precision) throws RestoptException {
        new IntegralIndexOfConnectivityConstraint(this.self(), minIIC, 1.0, distanceThreshold, precision).post();
    }

    default public void postNoNewPatchConstraint() {
        new NoNewPatchConstraint(this.self()).post();
    }
}

