% Generated by roxygen2 (4.0.2): do not edit by hand
\name{compute.intersections.sphere}
\alias{compute.intersections.sphere}
\title{Find the intersection of a plane with edges of triangles on
a sphere}
\usage{
compute.intersections.sphere(phi, lambda, T, n, d)
}
\arguments{
\item{phi}{Lattitude of grid points on sphere centred on origin.}

\item{lambda}{Longitude of grid points on sphere centred on origin.}

\item{T}{Triangulation}

\item{n}{Normal of plane}

\item{d}{Distance of plane along normal from origin.}
}
\value{
Matrix with same dimensions as \code{T}. Each row gives
the intersection of the plane  with the corresponding triangle in
\code{T}. Column 1 gives the fractional distance from vertex 2 to
vertex 3. Column 2 gives the fractional distance from vertex 3 to
vertex 1. Column 2 gives the fractional distance from vertex 1 to
vertex 2. A value of \code{NaN} indicates that the corresponding
edge lies in the plane. A value of \code{Inf} indicates that the
edge lies parallel to the plane but outside it.
}
\description{
Find the interections of the plane defined by the normal \code{n} and the
distance \code{d} expressed as a fractional distance along the side of
each triangle.
}
\author{
David Sterratt
}

