% Generated by roxygen2 (4.0.2): do not edit by hand
\name{mergePointsEdges}
\alias{mergePointsEdges}
\title{Merge stitched points and edges}
\usage{
mergePointsEdges(t)
}
\arguments{
\item{t}{A \code{StitchedOutline} object in which points that have
been added by stitching have been triangulated}
}
\value{
Adds following fields to input
\item{\code{Pt}}{Transformed point locations}
\item{\code{Tt}}{Transformed triangulation}
\item{\code{Ct}}{Transformed connection set}
\item{\code{Cut}}{Transformed symmetric connection set}
\item{\code{Bt}}{Transformed binary vector representation
of edge indicies onto a binary vector representation of the
indicies of the points linked by the edge}
\item{\code{Lt}}{Transformed edge lengths}
\item{\code{ht}}{Transformed correspondences}
\item{\code{u}}{Indicies of unique points in untransformed space}
\item{\code{U}}{Transformed indicies of unique points in untransformed space}
\item{\code{Rset}}{The set of points on the rim (which has been reoorded)}
\item{\code{Rsett}}{Transformed set of points on rim}
\item{\code{i0t}}{Transformed index of the landmark}
\item{H}{mapping from edges onto corresponding edges}
\item{Ht}{Transformed mapping from edges onto corresponding edges}
}
\description{
This function creates merged and transformed versions (all
suffixed with \code{t}) of a number of existing variables, as well
as a matrix \code{Bt}, which maps a binary vector representation
of edge indicies onto a binary vector representation of the
indicies of the points linked by the edge.
}
\author{
David Sterratt
}

