% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReconstructedOutline.R
\docType{data}
\name{ReconstructedOutline}
\alias{ReconstructedOutline}
\title{Reconstruct outline into spherical surface}
\format{An object of class \code{R6ClassGenerator} of length 25.}
\usage{
ReconstructedOutline
}
\description{
Reconstruct outline into spherical surface. Reconstruction
proceeds in a number of stages:
}
\details{
\enumerate{

\item The flat object is triangulated with at least \code{n}
triangles. This can introduce new vertices in the rim.

\item The triangulated object is stitched.

\item The stitched object is triangulated again, but this time it
is not permitted to add extra vertices to the rim.

\item The corresponding points determined by the stitching process
are merged to form a new set of merged points and a new
triangulation.

\item The merged points are projected roughly to a sphere.

\item The locations of the points on the sphere are moved so as to
minimise the energy function.
}
}
\section{Member functions}{


\describe{
\item{mapFlatToSpherical(P)}{Returns location of point on sphere corresponding to point on the flat outline. Input values:}
\describe{
\item{P}{Cartesian coordinates  on flat outline as a matrix with "X" and "Y" columns}
}}
}

\author{
David Sterratt
}
\keyword{datasets}
