% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TriangulatedFragment.R
\name{TriangulatedFragment}
\alias{TriangulatedFragment}
\title{Class to triangulate \link{Fragment}s}
\description{
A TriangulatedFragment contains a function to create a
  triangulated mesh over an fragment, and fields to hold the mesh
  information.
}
\author{
David Sterratt
}
\section{Super class}{
\code{\link[retistruct:Fragment]{retistruct::Fragment}} -> \code{TriangulatedFragment}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{T}}{3 column matrix in which each row contains IDs of
points of each triangle}

\item{\code{A}}{Area of each triangle in the  mesh - has same number of
elements as there are rows of \code{T}}

\item{\code{Cu}}{2 column matrix in which each row contains IDs of
points of edge in mesh}

\item{\code{L}}{Length of each edge in the mesh - has same number of
elements as there are rows of \code{Cu}}

\item{\code{A.signed}}{Signed area of each triangle generated using
\code{\link{tri.area.signed}}. Positive sign indicates points are
anticlockwise direction; negative indicates clockwise.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{TriangulatedFragment$new()}}
\item \href{#method-clone}{\code{TriangulatedFragment$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="retistruct" data-topic="Fragment" data-id="initializeFromPoints">}\href{../../retistruct/html/Fragment.html#method-initializeFromPoints}{\code{retistruct::Fragment$initializeFromPoints()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TriangulatedFragment$new(
  fragment,
  n = 200,
  suppress.external.steiner = FALSE,
  report = message
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fragment}}{\link{Fragment} to triangulate}

\item{\code{n}}{Minimum number of points in the triangulation}

\item{\code{suppress.external.steiner}}{If \code{TRUE} prevent the
addition of points in the outline. This happens to maintain
triangle quality.}

\item{\code{report}}{Function to report progress}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TriangulatedFragment$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
