% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_diagnostics.R
\name{summary.evpost}
\alias{summary.evpost}
\title{Summarizing an evpost object}
\usage{
\method{summary}{evpost}(object, ...)
}
\arguments{
\item{object}{an object of class "evpost", a result of a call to
\code{\link{rpost}}.}

\item{...}{Additional arguments passed on to \code{print} or \code{summary}.}
}
\value{
Prints
\itemize{
  \item {a summary of the simulated values, via
    \code{summary(object$sim_vals)}}
  \item {an estimate of the probability of acceptance, i.e.
    \code{object$pa}}
  \item {information about the ratio-of-uniforms bounding box, i.e.
    \code{object$box}}
}
}
\description{
\code{summary} method for class "evpost"
}
\examples{
# GP posterior
data(gom)
u <- stats::quantile(gom, probs = 0.65)
fp <- set_prior(prior = "flat", model = "gp", min_xi = -1)
gpg <- rpost(n = 1000, model = "gp", prior = fp, thresh = u, data = gom)
summary(gpg)
}
\seealso{
\code{\link{ru}} for descriptions of \code{object$sim_vals} and
  \code{object$box}.

\code{\link{plot.ru}} for a diagnostic plot (for \code{d} = 1
  and \code{d} = 2 only).
}

