% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counts.R
\name{counts}
\alias{counts}
\alias{n_times}
\alias{n}
\alias{between}
\alias{at_least}
\alias{at_most}
\title{Counts}
\usage{
n_times(x, n, type = c("greedy", "lazy", "possessive"))

between(x, low, high, type = c("greedy", "lazy", "possessive"))

at_least(x, n, type = c("greedy", "lazy", "possessive"))

at_most(x, n, type = c("greedy", "lazy", "possessive"))
}
\arguments{
\item{x}{A regex pattern.}

\item{n}{An integer number}

\item{type}{the type of match to perform.

There are three match types
\enumerate{
  \item \code{greedy}: match the longest string.  This is the default matching type.
  \item \code{lazy}: match the shortest string.  This matches the shortest string from the same anchor point, not necessarily the shortest global string.
  \item \code{possessive}: match and don't allow backtracking
}}

\item{low}{An integer number for the lower limit.}

\item{high}{An integer number for the upper limit.}
}
\description{
Functions to restrict a regex to a specific number
}
\section{Functions}{
\itemize{
\item \code{n_times}: \code{x} must occur exactly \code{n} times.

\item \code{between}: \code{x} must occur between \code{low} and \code{high} times.

\item \code{at_least}: \code{x} must occur at least \code{n} times.

\item \code{at_most}: \code{x} must occur at most \code{n} times.
}}

\seealso{
Other rex: \code{\link{\%or\%}}, \code{\link{capture}},
  \code{\link{character_class}}, \code{\link{group}},
  \code{\link{lookarounds}}, \code{\link{not}},
  \code{\link{rex}}, \code{\link{shortcuts}},
  \code{\link{wildcards}}
}
