% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineRP.R
\name{combineRP}
\alias{combineRP}
\title{Combine rfPermute objects}
\usage{
combineRP(...)
}
\arguments{
\item{\dots}{two or more objects of class \code{rfPermute}, to be combined 
into one.}
}
\description{
Combines two or more ensembles of \code{rfPermute} objects into 
  one, combining \code{randomForest} results, null distributions, 
  and re-calculating p-values.
}
\examples{
data(iris)
rp1 <- rfPermute(
  Species ~ ., iris, ntree = 50, norm.votes = FALSE, nrep = 100, num.cores = 1
)
rp2 <- rfPermute(
  Species ~ ., iris, ntree = 50, norm.votes = FALSE, nrep = 100, num.cores = 1
)
rp3 <- rfPermute(
  Species ~ ., iris, ntree = 50, norm.votes = FALSE, nrep = 100, num.cores = 1
)
rp.all <- combineRP(rp1, rp2, rp3)
rp.all

plotNull(rp.all) 

}
\seealso{
\code{\link[randomForest]{combine}}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
