% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/docs.R
\name{docs}
\alias{docs}
\title{docs}
\usage{
docs(table = "", server = getOption("FISHBASE_API", FISHBASE_API), ...)
}
\arguments{
\item{table}{the table for which the documentation should be displayed.  If no table is given,
documentation summarizing all available tables is shown.}

\item{server}{base URL to the FishBase API (by default). For SeaLifeBase, use http://fishbase.ropensci.org/sealifebase}

\item{...}{additional arguments to httr::GET}
}
\value{
A data.frame which lists the name of each table (if no table argument is given), along with a description
of the table and a URL linking to further information about the table.  If a specific table is named in the
table argument, then the function will return a data.frame listing all the fields (columns) found in that table,
a description of what the field label means, and the units in which the field is measured.  These descriptions of the
columns are not made available by FishBase.org and must be manually generated and curated by FishBase.org users.
At this time, many fields are still missing.  Please take a moment to fill in any fields you use in the source
table here: https://github.com/ropensci/fishbaseapi/tree/master/docs/docs-sources
}
\description{
documentation of tables and fields
}
\examples{
\donttest{
tables <- docs()
# Describe the diet table
dplyr::filter(tables, table == "diet")$description
}
}

