% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/list_fields.R
\name{list_fields}
\alias{list_fields}
\title{list_fields}
\usage{
list_fields(fields, server = getOption("FISHBASE_API", FISHBASE_API),
  implemented_only = TRUE)
}
\arguments{
\item{fields}{field (column name) to search for}

\item{server}{base URL to the FishBase API (by default). For SeaLifeBase, use http://fishbase.ropensci.org/sealifebase}

\item{implemented_only}{by default, only return those tables that have been implemented.}
}
\value{
a data frame listing the table names (matching function names in rfishbase) and the matching column names those tables have implemented.
}
\description{
list fields
}
\details{
method will use partial matching. Hence "Temp" will match column names such as "TempMin" and "TempMax", but "MinTemp" will not.  Likewise,
neither "Minimum" or "Temperature" will match "TempMin", so begin with the shortest query possible and refine based on search results when necessary.
Note also that there is no guarentee that the same column has the same value or same meaning in different tables.
}
\examples{
\dontrun{
list_fields("Temp")
}
}

