% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/species_list.R
\name{species_list}
\alias{species_list}
\title{species_list}
\usage{
species_list(Class = NULL, Order = NULL, Family = NULL,
  SubFamily = NULL, Genus = NULL, Species = NULL, SpecCode = NULL,
  SpeciesRefNo = NULL, all_taxa = load_taxa())
}
\arguments{
\item{Class}{Request all species in this taxonomic Class}

\item{Order}{Request all species in this taxonomic Order}

\item{Family}{Request all species in this taxonomic Family}

\item{SubFamily}{Request all species in this taxonomic SubFamily}

\item{Genus}{Request all species in this taxonomic Genus}

\item{Species}{Request all species in this taxonomic Species}

\item{SpecCode}{Request species name of species matching this SpecCode}

\item{SpeciesRefNo}{Request species name of all species matching this SpeciesRefNo}

\item{all_taxa}{The data.frame of all taxa used for the lookup. By default will be loaded
 from cache if available, otherwise must be downloaded from the server; about 13 MB, may be
 slow.}
}
\description{
Return the a species list given a taxonomic group
}
\details{
The first time the function is called it will download and cache the complete
}
\examples{
\donttest{
## All species in the Family
  species_list(Family = 'Scaridae')
## All species in the Genus
  species_list(Genus = 'Labroides')
}
}

