% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population_dynamics.R
\name{popchar}
\alias{popchar}
\title{popchar}
\usage{
popchar(species_list = NULL, fields = NULL, server = NULL, ...)
}
\arguments{
\item{species_list}{A vector of scientific names (each element as "genus species"). If empty, a table for all fish will be returned.}

\item{fields}{a character vector specifying which fields (columns) should be returned. By default,
all available columns recognized by the parser are returned.  Mostly for backwards compatibility as users can subset by column later}

\item{server}{can be set to either "fishbase" or "sealifebase" to switch between databases. NOTE: it is usually
easier to leave this as NULL and set the source instead using the environmental variable `FISHBASE_API`, e.g.
`Sys.setenv(FISHBASE_API="sealifebase")`.}

\item{...}{unused; for backwards compatibility only}
}
\description{
Table of maximum length (Lmax), weight (Wmax) and age (tmax)
}
\details{
See references for official documentation.  From FishBase.org:
This table presents information on maximum length (Lmax), 
weight (Wmax) and age (tmax) from various localities where a species
occurs. The largest values from this table are also entered in the
SPECIES table. The POPCHAR table also indicates whether the Lmax,
Wmax and tmax values or various combinations thereof refer to the
same individual fish.
}
\examples{
\dontrun{
popchar("Oreochromis niloticus")
}
}
\references{
http://www.fishbase.org/manual/english/fishbasethe_popchar_table.htm
}
