/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import java.util.HashSet;
import java.util.Set;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.reification.PropReif;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class ReificationConstraint
extends Constraint {
    protected final BoolVar bool;
    protected final Constraint trueCons;
    protected final Constraint falseCons;
    private final int[] indices;
    private final PropReif propReif;

    protected ReificationConstraint(BoolVar bVar, Constraint consIfBoolTrue, Constraint consIfBoolFalse) {
        super("REIFICATIONCONSTRAINT", ReificationConstraint.createProps(bVar, consIfBoolTrue, consIfBoolFalse));
        int p;
        this.propReif = (PropReif)this.propagators[0];
        this.propReif.setReifCons(this);
        this.trueCons = consIfBoolTrue;
        this.falseCons = consIfBoolFalse;
        this.bool = bVar;
        this.indices = new int[3];
        this.indices[0] = 1;
        this.indices[1] = this.indices[0] + this.trueCons.getPropagators().length;
        this.indices[2] = this.indices[1] + this.falseCons.getPropagators().length;
        for (p = this.indices[0]; p < this.indices[1]; ++p) {
            this.propagators[p].setReifiedSilent(this.bool);
        }
        for (p = this.indices[1]; p < this.indices[2]; ++p) {
            this.propagators[p].setReifiedSilent(this.bool.not());
        }
        this.trueCons.declareAs(Constraint.Status.REIFIED, -1);
        this.falseCons.declareAs(Constraint.Status.REIFIED, -1);
    }

    private static Propagator[] createProps(BoolVar bVar, Constraint trueCons, Constraint falseCons) {
        HashSet<Variable> setOfVars = new HashSet<Variable>();
        ReificationConstraint.prepareConstraint(bVar, trueCons, setOfVars);
        ReificationConstraint.prepareConstraint(bVar, falseCons, setOfVars);
        Variable[] allVars = ArrayUtils.append({bVar}, setOfVars.toArray(new Variable[0]));
        PropReif reifProp = new PropReif(allVars, trueCons, falseCons);
        return ArrayUtils.append({reifProp}, (Propagator[])trueCons.getPropagators().clone(), (Propagator[])falseCons.getPropagators().clone());
    }

    private static void prepareConstraint(BoolVar bVar, Constraint c, Set<Variable> setOfVars) {
        for (Propagator p : c.getPropagators()) {
            for (Variable v : p.getVars()) {
                if (v == bVar) continue;
                setOfVars.add(v);
            }
        }
    }

    public void activate(int idx) throws ContradictionException {
        Model model = this.propagators[0].getModel();
        assert (this.bool.isInstantiatedTo(1 - idx));
        for (int p = this.indices[idx]; p < this.indices[idx + 1]; ++p) {
            assert (this.propagators[p].isReifiedAndSilent());
            this.propagators[p].setReifiedTrue();
            this.propagators[p].propagate(PropagatorEventType.FULL_PROPAGATION.getMask());
            model.getSolver().getEngine().onPropagatorExecution(this.propagators[p]);
        }
    }

    @Override
    public ESat isSatisfied() {
        return this.propReif.isEntailed();
    }

    @Override
    public String toString() {
        return this.bool.toString() + "=>" + this.trueCons.toString() + ", !" + this.bool + "=>" + this.falseCons.toString();
    }
}

