/*
 * Decompiled with CFR 0.152.
 */
package org.flsgen.solver;

import com.github.cliftonlabs.json_simple.JsonArray;
import com.github.cliftonlabs.json_simple.JsonException;
import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.search.limits.FailCounter;
import org.chocosolver.solver.search.limits.TimeCounter;
import org.chocosolver.solver.search.strategy.Search;
import org.chocosolver.solver.variables.IntVar;
import org.flsgen.exception.FlsgenException;
import org.flsgen.grid.regular.square.PartialRegularSquareGrid;
import org.flsgen.grid.regular.square.RegularSquareGrid;
import org.flsgen.solver.LandscapeClass;
import org.flsgen.solver.LandscapeStructure;
import org.flsgen.solver.SquaresLandscapeClass;

public class LandscapeStructureSolver {
    public static final String KEY_NON_FOCAL_PLAND = "NON_FOCAL_PLAND";
    public static final String KEY_AREA = "AREA";
    public static final String KEY_AREA_MN = "AREA_MN";
    public static final String KEY_CA = "CA";
    public static final String KEY_PLAND = "PLAND";
    public static final String KEY_NP = "NP";
    public static final String KEY_PD = "PD";
    public static final String KEY_SPI = "SPI";
    public static final String KEY_LPI = "LPI";
    public static final String KEY_MESH = "MESH";
    public static final String KEY_SPLI = "SPLI";
    public static final String KEY_NPRO = "NPRO";
    public static final String KEY_SDEN = "SDEN";
    public static final String KEY_COHE = "COHE";
    public static final String KEY_DIVI = "DIVI";
    public static final String IS_SQUARE = "IS_SQUARE";
    protected RegularSquareGrid grid;
    protected int nbCells;
    protected Model model;
    protected List<LandscapeClass> landscapeClasses;
    protected IntVar totalSum;
    protected boolean isBuilt;
    protected IntVar[] decisionVariables;
    protected String maskRasterPath;

    public LandscapeStructureSolver(RegularSquareGrid grid) {
        this.grid = grid;
        this.nbCells = grid.getNbCells();
        this.model = new Model();
        this.landscapeClasses = new ArrayList<LandscapeClass>();
        this.isBuilt = false;
    }

    public LandscapeStructureSolver(int nbRows, int nbCols, int[] noDataCells, String maskRasterPath) throws IOException {
        this.maskRasterPath = maskRasterPath;
        this.grid = new PartialRegularSquareGrid(nbRows, nbCols, noDataCells);
        this.nbCells = this.grid.getNbCells();
        this.model = new Model();
        this.landscapeClasses = new ArrayList<LandscapeClass>();
        this.isBuilt = false;
    }

    public LandscapeClass landscapeClass(String name, int minNbPatches, int maxNbPatches, int minPatchSize, int maxPatchSize, boolean isSquare) throws FlsgenException {
        if (this.isBuilt) {
            throw new FlsgenException("Cannot add a landscape class to a landscape structure org.flsgen.solver which is already built");
        }
        LandscapeClass ls = isSquare ? new SquaresLandscapeClass(name, this.landscapeClasses.size(), this.grid, this.getModel(), minNbPatches, maxNbPatches, minPatchSize, maxPatchSize) : new LandscapeClass(name, this.landscapeClasses.size(), this.grid, this.getModel(), minNbPatches, maxNbPatches, minPatchSize, maxPatchSize);
        this.landscapeClasses.add(ls);
        return ls;
    }

    public void build() {
        this.totalSum = this.getModel().intVar(0, this.grid.getNbCells());
        IntVar[] sums = new IntVar[this.landscapeClasses.size()];
        IntVar landscapeSize = this.getModel().intVar(this.nbCells);
        for (int i = 0; i < this.landscapeClasses.size(); ++i) {
            sums[i] = this.landscapeClasses.get((int)i).sum;
            this.getModel().arithm(sums[i], "<", landscapeSize, "-", this.landscapeClasses.get((int)i).nbPatches).post();
        }
        this.getModel().sum(sums, "=", this.totalSum).post();
        this.getModel().arithm(this.totalSum, "<=", this.nbCells).post();
        this.decisionVariables = this.getModel().retrieveIntVars(true);
        this.isBuilt = true;
    }

    public RegularSquareGrid getGrid() {
        return this.grid;
    }

    public int getLandscapeSize() {
        return this.grid.getNbCells();
    }

    public void setNonFocalLandscapeProportion(double minProportion, double maxProportion) throws FlsgenException {
        if (minProportion < 0.0 || minProportion > 100.0 || maxProportion < 0.0 || maxProportion > 100.0) {
            throw new FlsgenException("Min and max class proportion must be between 0 and 100");
        }
        if (maxProportion < minProportion) {
            throw new FlsgenException("Max proportion must be greater than or equal to min proportion");
        }
        int min = (int)((double)this.getLandscapeSize() * minProportion / 100.0);
        int max = (int)((double)this.getLandscapeSize() * maxProportion / 100.0);
        this.getModel().arithm(this.totalSum, "<=", this.getLandscapeSize() - min).post();
        this.getModel().arithm(this.totalSum, ">=", this.getLandscapeSize() - max).post();
    }

    public void setRandomSearch() {
        long seed = System.currentTimeMillis();
        this.getModel().getSolver().setSearch(Search.randomSearch(this.decisionVariables, seed));
        this.getModel().getSolver().setRestartOnSolutions();
        this.getModel().getSolver().setGeometricalRestart(200L, 1.5, new FailCounter(this.getModel(), 1L), 100);
    }

    public void setDomOverWDegSearch() {
        this.getModel().getSolver().setSearch(Search.domOverWDegSearch(this.decisionVariables));
        this.getModel().getSolver().setGeometricalRestart(200L, 1.5, new FailCounter(this.getModel(), 1L), 100);
    }

    public void setDomOverWDegRefSearch() {
        this.getModel().getSolver().setSearch(Search.domOverWDegRefSearch(this.decisionVariables));
        this.getModel().getSolver().setGeometricalRestart(200L, 1.5, new FailCounter(this.getModel(), 1L), 100);
    }

    public void setActivityBasedSearch() {
        this.getModel().getSolver().setSearch(Search.activityBasedSearch(this.decisionVariables));
        this.getModel().getSolver().setGeometricalRestart(200L, 1.5, new FailCounter(this.getModel(), 1L), 100);
    }

    public void setDefaultSearch() {
        this.getModel().getSolver().setSearch(Search.defaultSearch(this.getModel()));
    }

    public void setConflictHistorySearch() {
        this.getModel().getSolver().setSearch(Search.conflictHistorySearch(this.decisionVariables));
        this.getModel().getSolver().setGeometricalRestart(200L, 1.5, new FailCounter(this.getModel(), 1L), 100);
    }

    public void setMinDomUBSearch() {
        this.getModel().getSolver().setSearch(Search.minDomUBSearch(this.decisionVariables));
    }

    public void setMinDomLBSearch() {
        this.getModel().getSolver().setSearch(Search.minDomLBSearch(this.decisionVariables));
    }

    public LandscapeStructure findSolution() {
        return this.findSolution(0);
    }

    public LandscapeStructure findSolution(int limitInSeconds) {
        if (!this.isBuilt) {
            this.build();
        }
        if (limitInSeconds > 0) {
            this.getModel().getSolver().addStopCriterion(new TimeCounter(this.getModel(), (long)((double)limitInSeconds * 1.0E9)));
        }
        if (this.getModel().getSolver().solve()) {
            return new LandscapeStructure(this);
        }
        return null;
    }

    public String toJSON() {
        JsonObject json = new JsonObject();
        json.put("nbRows", this.grid.getNbRows());
        json.put("nbCols", this.grid.getNbCols());
        if (this.maskRasterPath != null) {
            json.put("maskRasterPath", this.maskRasterPath);
        }
        JsonArray classes = new JsonArray();
        for (LandscapeClass l : this.landscapeClasses) {
            JsonObject cl = new JsonObject();
            cl.put("name", l.name);
            JsonArray nbPatches = new JsonArray();
            nbPatches.add(l.minNbPatches);
            nbPatches.add(l.maxNbPatches);
            cl.put("nbPatches", nbPatches);
            JsonArray patchSize = new JsonArray();
            patchSize.add(l.minPatchSize);
            patchSize.add(l.maxPatchSize);
            cl.put("patchSize", patchSize);
            classes.add(cl);
        }
        json.put("classes", classes);
        return Jsoner.prettyPrint(json.toJson());
    }

    public static LandscapeStructureSolver readFromJSON(String json, int nbRows, int nbCols, int[] noDataCells) throws IOException, JsonException, FlsgenException {
        LandscapeStructureSolver lStructSolver;
        JsonObject targets = (JsonObject)Jsoner.deserialize(new StringReader(json));
        if (targets.containsKey("maskRasterPath")) {
            String maskRasterPath = targets.get("maskRasterPath").toString();
            lStructSolver = new LandscapeStructureSolver(nbRows, nbCols, noDataCells, maskRasterPath);
        } else {
            if (!targets.containsKey("nbRows") || !targets.containsKey("nbCols")) {
                throw new IOException("Either 'maskRasterPath' or 'nbRows' and 'nbCols' are mandatory parameters but missing in input JSON file");
            }
            nbRows = Integer.parseInt(targets.get("nbRows").toString());
            nbCols = Integer.parseInt(targets.get("nbCols").toString());
            RegularSquareGrid grid = new RegularSquareGrid(nbRows, nbCols);
            lStructSolver = new LandscapeStructureSolver(grid);
        }
        if (!targets.containsKey("classes")) {
            throw new IOException("'classes' is a mandatory parameter but missing in input JSON file");
        }
        JsonArray classes = (JsonArray)targets.get("classes");
        for (Object cl : classes) {
            Boolean clAllDiff;
            double[] divi;
            double[] cohe;
            double[] sden;
            int[] npro;
            double[] spli;
            double[] mesh;
            int[] lpi;
            int[] spi;
            double[] pd;
            double[] pland;
            int[] ca;
            JsonObject cljson = (JsonObject)cl;
            if (!cljson.containsKey("name")) {
                throw new IOException("'name' is a mandatory parameter of classes but missing in input JSON file");
            }
            String name = cljson.get("name").toString();
            int[] nbPatches = LandscapeStructureSolver.getIntInterval(cljson, KEY_NP, true, name);
            int[] patchSize = LandscapeStructureSolver.getIntInterval(cljson, KEY_AREA, true, name);
            boolean isSquare = false;
            if (cljson.containsKey(IS_SQUARE)) {
                isSquare = Boolean.parseBoolean(cljson.get(IS_SQUARE).toString());
            }
            LandscapeClass landscapeClass = lStructSolver.landscapeClass(name, nbPatches[0], nbPatches[1], patchSize[0], patchSize[1], isSquare);
            double[] area_mn = LandscapeStructureSolver.getDoubleInterval(cljson, KEY_AREA_MN, false, name);
            if (area_mn != null) {
                landscapeClass.setMeanPatchArea(area_mn[0], area_mn[1]);
            }
            if ((ca = LandscapeStructureSolver.getIntInterval(cljson, KEY_CA, false, name)) != null) {
                landscapeClass.setClassArea(ca[0], ca[1]);
            }
            if ((pland = LandscapeStructureSolver.getDoubleInterval(cljson, KEY_PLAND, false, name)) != null) {
                landscapeClass.setLandscapeProportion(pland[0], pland[1]);
            }
            if ((pd = LandscapeStructureSolver.getDoubleInterval(cljson, KEY_PD, false, name)) != null) {
                landscapeClass.setPatchDensity(pd[0], pd[1]);
            }
            if ((spi = LandscapeStructureSolver.getIntInterval(cljson, KEY_SPI, false, name)) != null) {
                landscapeClass.setSmallestPatchSize(spi[0], spi[1]);
            }
            if ((lpi = LandscapeStructureSolver.getIntInterval(cljson, KEY_LPI, false, name)) != null) {
                landscapeClass.setLargestPatchSize(lpi[0], lpi[1]);
            }
            if ((mesh = LandscapeStructureSolver.getDoubleInterval(cljson, KEY_MESH, false, name)) != null) {
                landscapeClass.setMesh(mesh[0], mesh[1]);
            }
            if ((spli = LandscapeStructureSolver.getDoubleInterval(cljson, KEY_SPLI, false, name)) != null) {
                landscapeClass.setSplittingIndex(spli[0], spli[1]);
            }
            if ((npro = LandscapeStructureSolver.getIntInterval(cljson, KEY_NPRO, false, name)) != null) {
                landscapeClass.setNetProduct(npro[0], npro[1]);
            }
            if ((sden = LandscapeStructureSolver.getDoubleInterval(cljson, KEY_SPLI, false, name)) != null) {
                landscapeClass.setSplittingDensity(sden[0], sden[1]);
            }
            if ((cohe = LandscapeStructureSolver.getDoubleInterval(cljson, KEY_COHE, false, name)) != null) {
                landscapeClass.setDegreeOfCoherence(cohe[0], cohe[1]);
            }
            if ((divi = LandscapeStructureSolver.getDoubleInterval(cljson, KEY_DIVI, false, name)) != null) {
                landscapeClass.setDegreeOfDivision(divi[0], divi[1]);
            }
            if (!cljson.containsKey("ALL_DIFFERENT") || !(clAllDiff = (Boolean)cljson.get("ALL_DIFFERENT")).booleanValue()) continue;
            landscapeClass.setAllPatchesDifferentSize();
        }
        lStructSolver.build();
        double[] pland = LandscapeStructureSolver.getDoubleInterval(targets, KEY_NON_FOCAL_PLAND, false, "landscape");
        if (pland != null) {
            lStructSolver.setNonFocalLandscapeProportion(pland[0], pland[1]);
        }
        return lStructSolver;
    }

    public static int[] getIntInterval(JsonObject object, String key, boolean mandatory, String className) throws IOException {
        JsonArray interval;
        if (mandatory) {
            if (!object.containsKey(key)) {
                throw new IOException(key + " is a mandatory parameter of classes but missing in class " + className);
            }
        } else if (!object.containsKey(key)) {
            return null;
        }
        if ((interval = (JsonArray)object.get(key)).size() != 2) {
            throw new IOException(key + " must be an interval of two integer values (in class " + className + ")");
        }
        return new int[]{Integer.parseInt(interval.get(0).toString()), Integer.parseInt(interval.get(1).toString())};
    }

    public static double[] getDoubleInterval(JsonObject object, String key, boolean mandatory, String className) throws IOException {
        JsonArray interval;
        if (mandatory) {
            if (!object.containsKey(key)) {
                throw new IOException(key + " is a mandatory parameter of classes but missing in class " + className);
            }
        } else if (!object.containsKey(key)) {
            return null;
        }
        if ((interval = (JsonArray)object.get(key)).size() != 2) {
            throw new IOException(key + " must be an interval of two double values (in class " + className + ")");
        }
        return new double[]{Double.parseDouble(interval.get(0).toString()), Double.parseDouble(interval.get(1).toString())};
    }

    public Model getModel() {
        return this.model;
    }
}

