% Generated by roxygen2 (4.0.0): do not edit by hand
\name{occ_count}
\alias{occ_count}
\title{Get number of occurrence records.}
\usage{
occ_count(taxonKey = NULL, georeferenced = NULL, basisOfRecord = NULL,
  datasetKey = NULL, date = NULL, catalogNumber = NULL, country = NULL,
  hostCountry = NULL, year = NULL, from = 2000, to = 2012,
  type = "count", publishingCountry = "US", callopts = list(),
  nubKey = NULL, protocol = NULL)
}
\arguments{
\item{nubKey}{Species key. PARAMETER NAME CHANGED TO taxonKey.}

\item{taxonKey}{Species key}

\item{georeferenced}{Return only occurence records with lat/long data (TRUE) or
all records (FALSE, default).}

\item{basisOfRecord}{Basis of record}

\item{datasetKey}{Dataset key}

\item{date}{Collection date}

\item{year}{Year data were collected in}

\item{catalogNumber}{Catalog number. PARAMETER GONE.}

\item{country}{Country data was collected in}

\item{protocol}{Protocol. E.g., 'DWC_ARCHIVE'}

\item{hostCountry}{Country that hosted the data. PARAMETER GONE.}

\item{publishingCountry}{Publishing country, two letter ISO country code}

\item{from}{Year to start at}

\item{to}{Year to end at}

\item{type}{One of count (default), schema, basis_of_record, countries, or year.}

\item{callopts}{Pass on options to httr::GET for more refined control of
http calls, and error handling}
}
\value{
A single numeric value
}
\description{
Get number of occurrence records.
}
\examples{
\dontrun{
occ_count(basisOfRecord='OBSERVATION')
occ_count(georeferenced=TRUE)
occ_count(country='DENMARK')
occ_count(country='CANADA', georeferenced=TRUE, basisOfRecord='OBSERVATION')
occ_count(datasetKey='9e7ea106-0bf8-4087-bb61-dfe4f29e0f17')
occ_count(year=2012)
occ_count(taxonKey=2435099)
occ_count(taxonKey=2435099, georeferenced=TRUE)
occ_count(protocol='DWC_ARCHIVE')

# Just schema
occ_count(type='schema')

# Counts by basisOfRecord types
occ_count(type='basis_of_record')

# Counts by countries. publishingCountry must be supplied (default to US)
occ_count(type='countries')

# Counts by year. from and to years have to be supplied, default to 2000 and 2012
occ_count(type='year', from=2000, to=2012)

# Counts by publishingCountry, must supply a country (default to US)
occ_count(type='publishingCountry')
occ_count(type='publishingCountry', country='BZ')
}
}
\references{
\url{http://www.gbif.org/developer/summary}
}

