% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_image.R
\name{ee_utils_future_value}
\alias{ee_utils_future_value}
\title{The value of a future or the values of all elements in a container}
\usage{
ee_utils_future_value(future, stdout = TRUE, signal = TRUE, ...)
}
\arguments{
\item{future, }{x A Future, an environment, a list, or a list environment.}

\item{stdout}{If TRUE, standard output captured while resolving futures
is relayed, otherwise not.}

\item{signal}{If TRUE, \link[base]{conditions} captured while resolving
futures are relayed, otherwise not.}

\item{\dots}{All arguments used by the S3 methods.}
}
\value{
\code{value()} of a Future object returns the value of the future, which can
be any type of \R object.

\code{value()} of a list, an environment, or a list environment returns an
object with the same number of elements and of the same class.
Names and dimension attributes are preserved, if available.
All future elements are replaced by their corresponding \code{value()} values.
For all other elements, the existing object is kept as-is.

If \code{signal} is TRUE and one of the futures produces an error, then
that error is produced.
}
\description{
Gets the value of a future or the values of all elements (including futures)
in a container such as a list, an environment, or a list environment.
If one or more futures is unresolved, then this function blocks until all
queried futures are resolved.
}
\author{
Henrik Bengtsson \url{https://github.com/HenrikBengtsson/}
}
