% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-upload.R
\name{local_to_gcs}
\alias{local_to_gcs}
\title{Upload local files to Google Cloud Storage}
\usage{
local_to_gcs(x, bucket = NULL, quiet = FALSE)
}
\arguments{
\item{x}{Character. filename.}

\item{bucket}{bucket name you are uploading to}

\item{quiet}{Logical. Suppress info message.}
}
\value{
Character which represents the full path of the object in the GCS
bucket specified.
}
\description{
Upload images or tables to Google Cloud Storage
}
\examples{
\dontrun{
library(rgee)
library(stars)

# Initialize a specific Earth Engine account and
# Google Cloud Storage credentials
ee_Initialize(gcs = TRUE)

# # Define an image.
tif <- system.file("tif/L7_ETMs.tif", package = "stars")
local_to_gcs(x = tif, bucket = 'rgee_dev')
}
}
\seealso{
Other generic upload functions: 
\code{\link{ee_utils_create_manifest_image}()},
\code{\link{ee_utils_create_manifest_table}()}
}
\concept{generic upload functions}
