% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_install.R
\name{ee_install_set_pyenv}
\alias{ee_install_set_pyenv}
\title{Configure which version of Python to use with rgee}
\usage{
ee_install_set_pyenv(
  py_path = NULL,
  py_env = NULL,
  Renviron = "global",
  quiet = FALSE
)
}
\arguments{
\item{py_path}{The path to a Python interpreter}

\item{py_env}{The name of the environment}

\item{Renviron}{Character. If it is "global" the environment variables are set in
the .Renviron located in the Sys.getenv("HOME") folder. On the other hand,  if
it is "local" the environment variables are set in the .Renviron on the
working directory (getwd()). Finally, users can also enter a specific path
(see examples).}

\item{quiet}{Logical. Suppress info message}
}
\value{
no return value, called for setting EARTHENGINE_PYTHON in .Renviron
}
\description{
Configure which version of Python to use with rgee. This function creates two
environment variables: 'EARTHENGINE_PYTHON' and 'EARTHENGINE_ENV' both will be
saved into the file .Renviron.
}
\examples{
\dontrun{
library(rgee)
# ee_install_set_pyenv(py_path = "/usr/bin/python3", Renviron = "local")
# ee_install_set_pyenv(py_path = "/usr/bin/python3", Renviron = "/home/zgis/")
}
}
\seealso{
Other ee_install functions: 
\code{\link{ee_install_upgrade}()},
\code{\link{ee_install}()}
}
\concept{ee_install functions}
