% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{kernel_weights}
\alias{kernel_weights}
\title{Distance-based Kernel Spatial Weights}
\usage{
kernel_weights(
  sf_obj,
  bandwidth,
  kernel_method,
  use_kernel_diagonals = FALSE,
  power = 1,
  is_inverse = FALSE,
  is_arc = FALSE,
  is_mile = TRUE
)
}
\arguments{
\item{sf_obj}{An sf (simple feature) object}

\item{bandwidth}{A positive numeric value of bandwidth}

\item{kernel_method}{a string value, which has to be one of 'triangular',
'uniform', 'epanechnikov', 'quartic', 'gaussian'}

\item{use_kernel_diagonals}{(optional) FALSE (default) or TRUE, apply kernel
on the diagonal of weights matrix}

\item{power}{(optional) The power (or exponent) of a number says how many
times to use the number in a multiplication.}

\item{is_inverse}{(optional) FALSE (default) or TRUE, apply inverse on
distance value}

\item{is_arc}{(optional) FALSE (default) or TRUE, compute arc distance
between two observations}

\item{is_mile}{(optional) TRUE (default) or FALSE, convert distance unit from
mile to km.}
}
\value{
An instance of Weight-class
}
\description{
Create a kernel weights by specifying a bandwidth and a kernel
method
}
\examples{
library(sf)
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- st_read(guerry_path)
bandwidth <- min_distthreshold(guerry)
kernel_w <- kernel_weights(guerry, bandwidth, kernel_method = "uniform")
summary(kernel_w)
}
\keyword{kernel}
\keyword{weights}
