% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{quantile_breaks}
\alias{quantile_breaks}
\title{Quantile Breaks}
\usage{
quantile_breaks(k, df)
}
\arguments{
\item{k}{A numeric value indicates how many breaks}

\item{df}{A data frame with selected variable. E.g. guerry["Crm_prs"]}
}
\value{
A vector of numeric values of computed breaks
}
\description{
Quantile breaks data into groups that each have the same number
of observations
}
\examples{
library(sf)
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- st_read(guerry_path)
quantile_breaks(k=5, guerry['Crm_prs'])
}
