% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisa.R
\name{local_g}
\alias{local_g}
\title{Local Getis-Ord's G Statistics}
\usage{
local_g(
  w,
  df,
  permutations = 999,
  permutation_method = "complete",
  significance_cutoff = 0.05,
  cpu_threads = 6,
  seed = 123456789
)
}
\arguments{
\item{w}{An instance of Weight object}

\item{df}{A data frame with selected variable only. E.g. guerry["Crm_prs"]}

\item{permutations}{(optional) The number of permutations for the LISA
computation}

\item{permutation_method}{(optional) The permutation method used for the
LISA computation. Options are {'complete', 'lookup'}. Default is 'complete'.}

\item{significance_cutoff}{(optional) A cutoff value for significance
p-values to filter not-significant clusters}

\item{cpu_threads}{(optional) The number of cpu threads used for parallel
LISA computation}

\item{seed}{(optional) The seed for random number generator}
}
\value{
An instance of LISA-class
}
\description{
The function to apply Getis-Ord's local G statistics
}
\examples{
library(sf)
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- st_read(guerry_path)
queen_w <- queen_weights(guerry)
lisa <- local_g(queen_w, guerry["Crm_prs"])
lms <- lisa_values(lisa)
lms
}
