% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{add_create_video_request}
\alias{add_create_video_request}
\title{Add a create video request}
\usage{
add_create_video_request(
  google_slides_request = NULL,
  id,
  page_element_property,
  object_id = NULL
)
}
\arguments{
\item{google_slides_request}{(Optional) A Google Slides Request object which is used to manage requests to the API}

\item{id}{The video source's unique identifier for this video. e.g. For YouTube
video https://www.youtube.com/watch?v=7U3axjORYZ0 , the ID is 7U3axjORYZ0.}

\item{page_element_property}{A list that contains a page element property. The page element is to be
generated by the page_element_property function in this package.}

\item{object_id}{(Optional) A character vector to name the object created instead of leaving it to Google}
}
\description{
Add a create video request
}
\examples{
\dontrun{
library(rgoogleslides)
rgoogleslides::authorize()

# Define the presentation slide id (Can be retrieved from the url of the slides)
slides_id <- "<slide-id>"

# Define the youtube video id (Can be retrieved from the url of the youtube video)
youtube_id <- "<youtube-id>"

page_element <- aligned_page_element_property("p", align = "full")
request <- add_create_video_request(id = youtube_id, page_element_property = page_element)
commit_to_slides(slide_id, request)
}
}
