% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representation-kernel-methods.R
\name{PersistenceWeightedGaussianKernel}
\alias{PersistenceWeightedGaussianKernel}
\title{Kernel Representation: Persistence Weighted Gaussian Kernel}
\description{
Computes the persistence weighted Gaussian kernel matrix from a
list of persistence diagrams. The persistence weighted Gaussian kernel is
computed by convolving the persistence diagram points with weighted
Gaussian kernels. See http://proceedings.mlr.press/v48/kusano16.html for
more details.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
ac <- AlphaComplex$new(points = X)
st <- ac$create_simplex_tree()
dgm <- st$compute_persistence()$persistence_intervals_in_dimension(0)
ds <- DiagramSelector$new(use = TRUE)
dgm <- ds$apply(dgm)
pwgk <- PersistenceWeightedGaussianKernel$new()
pwgk$apply(dgm, dgm)
pwgk$fit_transform(list(dgm))
\dontshow{\}) # examplesIf}
}
\author{
Mathieu Carrière
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:KernelRepresentationStep]{rgudhi::KernelRepresentationStep}} -> \code{PersistenceWeightedGaussianKernel}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PersistenceWeightedGaussianKernel-new}{\code{PersistenceWeightedGaussianKernel$new()}}
\item \href{#method-PersistenceWeightedGaussianKernel-clone}{\code{PersistenceWeightedGaussianKernel$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="KernelRepresentationStep" data-id="apply"><a href='../../rgudhi/html/KernelRepresentationStep.html#method-KernelRepresentationStep-apply'><code>rgudhi::KernelRepresentationStep$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="KernelRepresentationStep" data-id="fit"><a href='../../rgudhi/html/KernelRepresentationStep.html#method-KernelRepresentationStep-fit'><code>rgudhi::KernelRepresentationStep$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="KernelRepresentationStep" data-id="fit_transform"><a href='../../rgudhi/html/KernelRepresentationStep.html#method-KernelRepresentationStep-fit_transform'><code>rgudhi::KernelRepresentationStep$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="KernelRepresentationStep" data-id="transform"><a href='../../rgudhi/html/KernelRepresentationStep.html#method-KernelRepresentationStep-transform'><code>rgudhi::KernelRepresentationStep$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PersistenceWeightedGaussianKernel-new"></a>}}
\if{latex}{\out{\hypertarget{method-PersistenceWeightedGaussianKernel-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{PersistenceWeightedGaussianKernel}} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PersistenceWeightedGaussianKernel$new(
  bandwidth = 1,
  weight = ~1,
  kernel_approx = NULL,
  n_jobs = 1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bandwidth}}{A numeric value specifying the bandwidth of the Gaussian
kernel with which persistence diagrams will be convolved. Defaults to
\code{1.0}.}

\item{\code{weight}}{A function or a formula coercible into a function via
\code{\link[rlang:as_function]{rlang::as_function()}} specifying the weight function for the
persistence diagram points. Defaults to the constant function \code{~ 1}.
This function must be defined on 2D points, i.e. lists or arrays of the
form \eqn{[p_x,p_y]}.}

\item{\code{kernel_approx}}{A Python class specifying the kernel approximation
class used to speed up computation. Defaults to \code{NULL}. Common kernel
approximations classes can be found in the \strong{scikit-learn} library
(such as \code{RBFSampler} for instance).}

\item{\code{n_jobs}}{An integer value specifying the number of jobs to use for
the computation. Defaults to \code{1}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{PersistenceWeightedGaussianKernel}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PersistenceWeightedGaussianKernel-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PersistenceWeightedGaussianKernel-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PersistenceWeightedGaussianKernel$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
