% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sklearn-cluster.R
\name{SpectralClustering}
\alias{SpectralClustering}
\title{Performs clustering according to the spectral clustering algorithm}
\description{
This is a wrapper around the Python class
\href{https://scikit-learn.org/stable/modules/generated/sklearn.cluster.SpectralClustering.html#sklearn.cluster.SpectralClustering}{sklearn.cluster.SpectralClustering}.
}
\examples{
\dontshow{if (reticulate::py_module_available("sklearn.cluster")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cl <- SpectralClustering$new()
\dontshow{\}) # examplesIf}
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:BaseClustering]{rgudhi::BaseClustering}} -> \code{SpectralClustering}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SpectralClustering-new}{\code{SpectralClustering$new()}}
\item \href{#method-SpectralClustering-clone}{\code{SpectralClustering$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="apply"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-apply'><code>rgudhi::SKLearnClass$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit'><code>rgudhi::SKLearnClass$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit_transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit_transform'><code>rgudhi::SKLearnClass$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-transform'><code>rgudhi::SKLearnClass$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpectralClustering-new"></a>}}
\if{latex}{\out{\hypertarget{method-SpectralClustering-new}{}}}
\subsection{Method \code{new()}}{
The \link{SpectralClustering} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpectralClustering$new(
  n_clusters = 8L,
  eigen_solver = c("arpack", "lobpcg", "amg"),
  n_components = NULL,
  random_state = NULL,
  n_init = 10L,
  gamma = 1,
  affinity = c("rbf", "nearest_neighbors", "precomputed",
    "precomputed_nearest_neighbors"),
  n_neighbors = 10L,
  eigen_tol = "auto",
  assign_labels = c("kmeans", "discretize", "cluster_qr"),
  degree = 3L,
  coef0 = 1,
  kernel_params = NULL,
  n_jobs = 1L,
  verbose = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_clusters}}{An integer value specifying the dimension of the
projection subspace. Defaults to \code{8L}.}

\item{\code{eigen_solver}}{A string specifying the eigenvalue decomposition
strategy to use. Choices are \code{c("arpack", "lobpcg", "amg")}. AMG
requires \strong{pyamg} to be installed. It can be faster on very large,
sparse problems, but may also lead to instabilities. Defaults to
\code{"arpack"}.}

\item{\code{n_components}}{An integer value specifying the number of
eigenvectors to use for the spectral embedding. Defaults to \code{NULL}, in
which case, \code{n_clusters} is used.}

\item{\code{random_state}}{An integer value specifying a pseudo random number
generator used for the initialization of the \code{lobpcg} eigenvectors
decomposition when \code{eigen_solver == "amg"}, and for the k-means
initialization. Defaults to \code{NULL} which uses clock time.}

\item{\code{n_init}}{An integer value specifying the number of time the k-means
algorithm will be run with different centroid seeds. The final results
will be the best output of \code{n_init} consecutive runs in terms of
inertia. Only used if \code{assign_labels == "kmeans"}. Defaults to \code{10L}.}

\item{\code{gamma}}{A numeric value specifying the kernel coefficient for \code{rbf},
\code{poly}, \code{sigmoid}, \code{laplacian} and \code{chi2} kernels. Ignored for
\code{affinity == "nearest_neighbors"}. Defaults to \code{1.0}.}

\item{\code{affinity}}{Either a string or an object coercible to a function via
\code{\link[rlang:as_function]{rlang::as_function()}} specifying how to construct the affinity
matrix:
\itemize{
\item \code{"nearest_neighbors"}: construct the affinity matrix by computing a
graph of nearest neighbors;
\item \code{"rbf"}: construct the affinity matrix using a radial basis function
(RBF) kernel;
\item \code{"precomputed"}: interpret \code{X} as a precomputed affinity matrix,
where larger values indicate greater similarity between instances;
\item \code{"precomputed_nearest_neighbors"}: interpret \code{X} as a sparse graph of
precomputed distances, and construct a binary affinity matrix from the
\code{n_neighbors} nearest neighbors of each instance;
\item one of the kernels supported by
\href{https://scikit-learn.org/stable/modules/generated/sklearn.metrics.pairwise.pairwise_kernels.html}{pairwise_kernels}.
}

Only kernels that produce similarity scores (non-negative values that
increase with similarity) should be used. This property is not checked
by the clustering algorithm.

Defaults to \code{"rbf"}.}

\item{\code{n_neighbors}}{An integer value specifying the number of neighbors to
use when constructing the affinity matrix using the nearest neighbors
method. Ignored for \code{affinity == "rbf"}. Defaults to \code{10L}.}

\item{\code{eigen_tol}}{A numeric value specifying the stopping criterion for
the eigen-decomposition of the Laplacian matrix. If \code{eigen_tol == "auto"}, then the passed tolerance will depend on the \code{eigen_solver}:
\itemize{
\item If \code{eigen_solver == "arpack"}, then \code{eigen_tol = 0.0};
\item If \code{eigen_solver == "lobpcg"} or \code{eigen_solver == "amg"}, then
\code{eigen_tol == NULL} which configures the underlying \code{lobpcg} solver to
automatically resolve the value according to their heuristics.
}

Note that when using \code{eigen_solver == "lobpcg"} or \code{eigen_solver == "amg"} values of \code{tol < 1e-5} may lead to convergence issues and should
be avoided.

Defaults to \code{"auto"}.}

\item{\code{assign_labels}}{A string specifying the strategy for assigning
labels in the embedding space. There are two ways to assign labels
after the Laplacian embedding. k-means is a popular choice
(\code{"kmeans"}), but it can be sensitive to initialization. Discretization
is another approach which is less sensitive to random initialization
(\code{"discretize"}). The \code{cluster_qr} method directly extract clusters
from eigenvectors in spectral clustering. In contrast to k-means and
discretization, \code{cluster_qr} has no tuning parameters and runs no
iterations, yet may outperform k-means and discretization in terms of
both quality and speed. Defaults to \code{"kmeans"}.}

\item{\code{degree}}{An integer value specifying the degree of the polynomial
kernel. Ignored by other kernels. Defaults to \code{3L}.}

\item{\code{coef0}}{A numeric value specifying the value of the zero coefficient
for polynomial and sigmoid kernels. Ignored by other kernels. Defaults
to \code{1.0}.}

\item{\code{kernel_params}}{A named list specifying extra arguments to the
kernels passed as functions. Ignored by other kernels. Defaults to
\code{NULL}.}

\item{\code{n_jobs}}{An integer value specifying the number of parallel jobs to
run for neighbors search. Defaults to \code{1L}. A value of \code{-1L} means
using all processors.}

\item{\code{verbose}}{A boolean value specifying the verbosity mode. Defaults to
\code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \link{SpectralClustering}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpectralClustering-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SpectralClustering-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpectralClustering$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
