% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ortho_request.R
\name{ortho_request}
\alias{ortho_request}
\alias{orto_request}
\title{Get metadata and links to available orthoimages}
\usage{
ortho_request(x)

orto_request(x)
}
\arguments{
\item{x}{an \code{sf}, \code{sfc} or \code{SpatVector} object with one or more features
(requests are based on the bounding boxes of the provided features)}
}
\value{
a data frame with metadata and links to the orthoimages
}
\description{
Get metadata and links to available orthoimages
}
\details{
The server can return a maximum of 1000 records in a single query.
If your area of interest exceeds this limit, you can generate a grid of
smaller polygons (\code{\link[sf:st_make_grid]{sf::st_make_grid()}}) or a regular grid of points
(\code{\link[sf:st_sample]{sf::st_sample()}}).
}
\examples{
\dontrun{
library(sf)
polygon_path = system.file("datasets/search_area.gpkg", package = "rgugik")
polygon = read_sf(polygon_path)
req_df = ortho_request(polygon)

# simple filtering by attributes
req_df = req_df[req_df$composition == "CIR", ]
req_df = req_df[req_df$resolution <= 0.25 & req_df$year >= 2016, ]
}
}
\seealso{
\code{\link[=tile_download]{tile_download()}}
}
