% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string.R
\name{shortenStr}
\alias{shortenStr}
\title{Shorten strings to a given number of characters}
\usage{
shortenStr(str, nchar = 8)
}
\arguments{
\item{str}{A vector of strings}

\item{nchar}{The maximal number of characters to keep}
}
\value{
A vector of strings of the same length as the input, with each string shortened to the desired length 

Strings with more characters than \code{nchar} will be shortened.
}
\description{
Shorten strings to a given number of characters
}
\note{
\code{NA} will be kept as they are
}
\examples{

inputStrs <- c("abc", "abcd", "abcde", NA)
shortenStr(inputStrs, nchar=4)
## expected outcome: abc, abcd, abcd..., NA

}
