% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BWN.R
\name{bwn}
\alias{bwn}
\alias{d_bwn}
\alias{r_bwn}
\alias{fit_bwn_mle}
\title{Density evaluation, sampling, and parameter estimation of the
bivariate wrapped normal distribution}
\usage{
d_bwn(x, mu, Sigma, kmax = 2)

r_bwn(n, mu, Sigma)

fit_bwn_mle(
  x,
  kmax = 2,
  lower = c(-pi, -pi, 0.001, 0.001, -1),
  upper = c(pi, pi, 20, 20, 1),
  ...
)
}
\arguments{
\item{x}{matrix of size \code{c(nx, 2)} with the angles on which the density
is evaluated.}

\item{mu}{circular means of the density, a vector of length \code{2}.}

\item{Sigma}{covariance matrix of size \code{c(2, 2)}.}

\item{kmax}{integer number up to truncate the wrapped normal series in
\code{-kmax:kmax}. Defaults to \code{2}.}

\item{n}{sample size.}

\item{lower, upper}{vector of length \code{5} with the bounds of the
parameters for the maximum likelihood optimizer.}

\item{...}{further parameters passed to
\code{\link[=sdetorus]{mleOptimWrapper}}.}
}
\value{
\itemize{
  \item \code{d_bwn}: a vector of length \code{nx} with the density evaluated
  at \code{x}.
  \item \code{r_bwn}: a matrix of size \code{c(n, 2)} with the random sample.
  \item \code{fit_bwn_mle}: a list with the parameters
  \eqn{(\boldsymbol{\mu}, \boldsymbol{\Sigma})} and the object \code{opt}
  containing the optimization summary.
}
}
\description{
Computation of the density of the bivariate wrapped normal.

Simulation of pairs of samples from a bivariate wrapped normal.

Maximum likelihood estimation of the parameters
\eqn{(\boldsymbol{\mu}, \boldsymbol{\Sigma})}.
}
\examples{
## Density evaluation

mu <- c(0, 0)
Sigma <- 3 * matrix(c(1.5, 0.75, 0.75, 1), nrow = 2, ncol = 2)
nth <- 50
th <- seq(-pi, pi, l = nth)
x <- as.matrix(expand.grid(th, th))
d <- d_bwn(x = x, mu = mu, Sigma = Sigma)
filled.contour(th, th, matrix(d, nth, nth), col = viridisLite::viridis(31),
               levels = seq(0, max(d), l = 30))

## Sampling and estimation

n <- 100
samp <- r_bwn(n = 100, mu = mu, Sigma = Sigma)
(param_mle <- fit_bwn_mle(samp)$par)
}
