% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictiveinfo.R
\name{predictive_info}
\alias{predictive_info}
\title{Predictive Information}
\usage{
predictive_info(series, kpast, kfuture, local = FALSE)
}
\arguments{
\item{series}{Vector or matrix specifying one or more time series.}

\item{kpast}{Integer giving the history length.}

\item{kfuture}{Integer giving the future length.}

\item{local}{Boolean specifying whether to compute the local predictive
information.}
}
\value{
Numeric giving the average predictive information or a vector giving
        the local predictive information.
}
\description{
Compute the predictive information from a time series with history length
\code{kpast} and future length \code{kfuture}.
}
\examples{
# One initial condition
xs <- c(0, 0, 1, 1, 0, 0, 1, 1, 0)
predictive_info(xs, kpast = 1, kfuture = 2) # 0.985228

# [0.807, 0.807, 1.222, 1.222, 0.807, 0.807, 1.222]
predictive_info(xs, kpast = 1, kfuture = 2, local = TRUE)

# Multiple initial conditions
xs      <- matrix(0, nrow = 9, ncol = 2)
xs[, 1] <- c(0, 0, 1, 1, 0, 0, 1, 1, 0)
xs[, 2] <- c(0, 1, 0, 1, 0, 1, 0, 1, 0)
predictive_info(xs, kpast = 1, kfuture = 2) # 0.244905

# [, 1] -0.515 0.807 -0.363 1.222 -0.515 0.807 -0.363
# [, 2] 0.222 0.485  0.222 0.485  0.222 0.485  0.222
predictive_info(xs, kpast = 1, kfuture = 2, local = TRUE)

}
