% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{pMC.age}
\alias{pMC.age}
\title{Calculate C14 ages from pMC values.}
\usage{
pMC.age(mn, sdev = c(), ratio = 100, decimals = 0)
}
\arguments{
\item{mn}{Reported mean of the pMC.}

\item{sdev}{Reported error of the pMC.}

\item{ratio}{Most modern-date values are reported against \code{100}. If it is against \code{1} instead, use \code{1} here.}

\item{decimals}{Amount of decimals required for the radiocarbon age.}
}
\value{
Radiocarbon ages from pMC values. If pMC values are above 100\%, the resulting radiocarbon ages will be negative.
}
\description{
Calculate C14 ages from pMC values of radiocarbon dates.
}
\details{
Post-bomb dates are often reported as pMC or percent modern carbon. Since Bacon expects radiocarbon ages,
 this function can be used to calculate radiocarbon ages from pMC values. The reverse function is \link{age.pMC}.
}
\examples{
  pMC.age(110, 0.5) # a postbomb date, so with a negative 14C age
  pMC.age(80, 0.5) # prebomb dates can also be calculated
  pMC.age(.8, 0.005, ratio=1) # throws a warning, use F14C.age instead
}
