% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bioconductor_data.R
\name{get_bioconductor_package_url}
\alias{get_bioconductor_package_url}
\title{Retrieve Bioconductor Package URL}
\usage{
get_bioconductor_package_url(
  package_name,
  package_version = NULL,
  release_data
)
}
\arguments{
\item{package_name}{A character string specifying the name of the Bioconductor package.}

\item{package_version}{(Optional) A character string specifying the package version. Defaults to `NULL`, which retrieves the latest version.}

\item{release_data}{A list containing Bioconductor release information.}
}
\value{
A list containing the following elements:
 \item{url}{The URL of the source package (if available).}
 \item{version}{The specified or latest available package version.}
 \item{last_version}{The last available version of the package.}
 \item{all_versions}{A vector of all discovered versions of the package.}
 \item{bioconductor_version_package}{The Bioconductor version associated with the package.}
 \item{archived}{A logical value indicating whether the package is archived.}
}
\description{
This function fetches the source package URL for a given Bioconductor package.
If no version is specified, it retrieves the latest available version.
Currently, this function is not able to fetch archived package version for a bioconductor version
}
\examples{
\dontrun{
release_data <- list(
  list(release = "3.12"),
  list(release = "3.13"),
  list(release = "3.14")
)

get_bioconductor_package_url("GenomicRanges", release_data = release_data)



}
}
