% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependency_tree.R
\name{download_and_parse_dependencies}
\alias{download_and_parse_dependencies}
\title{Download and Parse Dependencies of an R Package}
\usage{
download_and_parse_dependencies(package_name, version = NA)
}
\arguments{
\item{package_name}{A character string representing the name of the package to download.}

\item{version}{A character string specifying the version of the package to download. Defaults to `NA`, which fetches the latest version.}
}
\value{
A data frame containing:
	- `package`: The name of the dependency.
	- `type`: The type of dependency (e.g., "Imports").
	- `parent_package`: The original package for which dependencies were parsed.
}
\description{
This function downloads a specific version of an R package from a repository,
extracts it, and parses its dependencies from the DESCRIPTION file.
}
\examples{
\dontrun{
download_and_parse_dependencies("dplyr")
}
}
