% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_traceability_matrix.R
\name{generate_traceability_matrix}
\alias{generate_traceability_matrix}
\title{Assess an R Package traceability matrix from package name and version}
\usage{
generate_traceability_matrix(
  package_name,
  version = NA,
  repos = NULL,
  execute_coverage = FALSE
)
}
\arguments{
\item{package_name}{A character string specifying the name of the package to assess.}

\item{version}{A character string specifying the version of the package to assess. Default is `NA`, which assesses the latest version.}

\item{repos}{A character string specifying the repo directly. Default is NULL, which uses the mirrors}

\item{execute_coverage}{Logical (`TRUE`/`FALSE`). If `TRUE`, execute test coverage.}
}
\value{
The function returns package traceability_matrix
If the package cannot be downloaded or installed, an error message is returned.
}
\description{
This function use `risk.assessr::create_traceability_matrix` function with only the package name and version
}
\examples{
\dontrun{
r <- getOption("repos")
# save current repo options  
old <- options(repos = r)
r["CRAN"] = "http://cran.us.r-project.org"
options(repos = r)#' 

results_no_test_covr <- generate_traceability_matrix(
 "here", 
 version = "1.0.1", 
 execute_coverage = FALSE
)

results_test_covr <- generate_traceability_matrix(
 "here", 
 version = "1.0.1", 
 execute_coverage = TRUE
)

# restore user's repo options
options(old)

print(results_no_test_covr)

print(results_test_covr)
}

}
