% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcSeCox.R
\name{selectJump}
\alias{selectJump}
\title{Evaluate the influence function at selected times}
\usage{
selectJump(IF, times, type)
}
\arguments{
\item{IF}{influence function returned by iidCox}

\item{times}{the times at which the influence function should be assessed}

\item{type}{can be \code{"hazard"} or/and \code{"cumhazard"}.}
}
\value{
An object with the same dimensions as IF
}
\description{
Evaluate the influence function at selected times
}
\examples{
\dontrun{
library(survival)

set.seed(10)
d <- SimSurv(1e2)
fit <- coxph(Surv(time,status)~X1 * X2,data=d, ties="breslow", x = TRUE, y = TRUE)

IFall <- iidCox(fit)
selectJump(IFall, times = 1:2, type = "cumhazard") 
 
}
}
\author{
Brice Ozenne broz@sund.ku.dk
}
