% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictRisk.R
\name{penalizedS3}
\alias{penalizedS3}
\title{S3-wrapper for S4 function penalized}
\usage{
penalizedS3(formula, data, type = "elastic.net", lambda1, lambda2, fold,
  ...)
}
\arguments{
\item{formula}{Communicated outcome and explanatory variables. See examples.}

\item{data}{Data set in which formula is to be interpreted}

\item{type}{String specifying the type of penalization. Should match one of the following values:
\code{"ridge"}, \code{"lasso"}, \code{"elastic.net"}.}

\item{lambda1}{Lasso penalty}

\item{lambda2}{ridge penalty}

\item{fold}{passed to \code{penalized::profL1}}

\item{...}{Arguments passed to penalized}
}
\description{
S3-wrapper for S4 function penalized
}
\examples{
library(prodlim)
\dontrun{
## too slow
library(penalized)
set.seed(8)
d <- sampleData(200,outcome="binary")
newd <- sampleData(80,outcome="binary")
fitridge <- penalizedS3(Y~X1+X2+pen(7:8), data=d, type="ridge",
standardize=TRUE, model="logistic",trace=FALSE)
fitlasso <- penalizedS3(Y~X1+X2+pen(7:8), data=d, type="lasso",
standardize=TRUE, model="logistic",trace=FALSE)
# fitnet <- penalizedS3(Y~X1+X2+pen(7:8), data=d, type="elastic.net",
# standardize=TRUE, model="logistic",trace=FALSE)
predictRisk(fitridge,newdata=newd)
predictRisk(fitlasso,newdata=newd)
# predictRisk(fitnet,newdata=newd)
Score(list(fitridge),data=newd,formula=Y~1)
Score(list(fitridge),data=newd,formula=Y~1,split.method="bootcv",B=2)
}
\dontrun{ data(nki70) ## S4 fit
pen <- penalized(Surv(time, event), penalized = nki70[,8:77],
                 unpenalized = ~ER+Age+Diam+N+Grade, data = nki70,
lambda1 = 1)
penS3 <- penalizedS3(Surv(time,event)~ER+Age+Diam+pen(8:77)+N+Grade,
                     data=nki70, lambda1=1)
## or
penS3 <- penalizedS3(Surv(time,event)~ER+pen(TSPYL5,Contig63649_RC)+pen(10:77)+N+Grade,
                     data=nki70, lambda1=1)
## also this works
penS3 <- penalizedS3(Surv(time,event)~ER+Age+pen(8:33)+Diam+pen(34:77)+N+Grade,
                    data=nki70, lambda1=1)
}
}
