% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_pal.R
\docType{data}
\name{pal_bwp}
\alias{pal_bwp}
\title{Alternative color palette for black-and-white graphs (for printing purposes).}
\format{
An object of class \code{character} of length 16.
}
\usage{
pal_bwp
}
\description{
\code{pal_bwp} is initialized to a vector of named elements (colors)
to define a strict (black-and-white, b/w) scenario color scheme
that is suited for printing graphs in black-and-white.
}
\details{
\code{pal_bwp} is a stricter version of the greyscale
palette \code{\link{pal_bw}} that enforces
black text and lines on white boxes. Thus, the bounds of frequency boxes
are invisible on white backgrounds unless the default of
\code{f_lwd = 0} is changed (e.g., to \code{f_lwd = 1}).

Some background colors (of frequencies) are also used as
foreground colors (of probabilities, e.g.,
in \code{\link{plot_curve}} and \code{\link{plot_plane}}).
For this reason, the plotting functions detect and
adjust colors and/or line settings when \code{pal_bwp}
is used.

See \code{\link{pal_bw}} for a more permissible black-and-white
palette that uses various shades of grey for frequency boxes
so that their bounds remain visible on a white background
when \code{f_lwd = 0} (as per default for most graphs).

See \code{\link{pal}} for default color information.

Assign \code{pal <- pal_bwp} to use as default color scheme
throughout the \bold{riskyr} package.
}
\examples{
pal_bwp        # shows all color names and current values
pal_bwp["hi"]  # shows the current color for hits (true positives, TP)
pal_bwp["hi"] <- "gold" # defines a new color for hits (true positives, TP)

}
\seealso{
\code{\link{pal}} contains current color information;
\code{\link{init_pal}} initializes color information.

Other lists containing current scenario information: 
\code{\link{accu}},
\code{\link{freq}},
\code{\link{num}},
\code{\link{pal_bw}},
\code{\link{pal_kn}},
\code{\link{pal_mbw}},
\code{\link{pal_mod}},
\code{\link{pal_org}},
\code{\link{pal_rgb}},
\code{\link{pal_unikn}},
\code{\link{pal_vir}},
\code{\link{pal}},
\code{\link{prob}},
\code{\link{txt_TF}},
\code{\link{txt_org}},
\code{\link{txt}}
}
\concept{lists containing current scenario information}
\keyword{datasets}
