% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fnet.R
\name{plot_fnet}
\alias{plot_fnet}
\title{Plot frequency net diagram of frequencies and probabilities.}
\source{
Binder, K., Krauss, S., and Wiesner, P. (2020).
A new visualization for probabilistic situations containing two binary events: The frequency net.
Frontiers in Psychology, 11, 750. doi: 10.3389/fpsyg.2020.00750
}
\usage{
plot_fnet(
  prev = num$prev,
  sens = num$sens,
  mirt = NA,
  spec = num$spec,
  fart = NA,
  N = num$N,
  by = "cddc",
  area = "no",
  scale = "p",
  round = TRUE,
  f_lbl = "num",
  f_lbl_sep = NA,
  f_lwd = 0,
  p_lwd = 1,
  p_scale = FALSE,
  p_lbl = "mix",
  arr_c = NA,
  joint_p = TRUE,
  lbl_txt = txt,
  title_lbl = txt$scen_lbl,
  cex_lbl = 0.9,
  cex_p_lbl = NA,
  col_pal = pal,
  mar_notes = FALSE,
  ...
)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).
\code{sens} is optional when its complement \code{mirt} is provided.}

\item{mirt}{The decision's miss rate \code{\link{mirt}}
(i.e., the conditional probability of a negative decision
provided that the condition is \code{TRUE}).
\code{mirt} is optional when its complement \code{sens} is provided.}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).
\code{spec} is optional when its complement \code{fart} is provided.}

\item{fart}{The decision's false alarm rate \code{\link{fart}}
(i.e., the conditional probability
of a positive decision provided that the condition is \code{FALSE}).
\code{fart} is optional when its complement \code{spec} is provided.}

\item{N}{The number of individuals in the population.
A suitable value of \code{\link{N}} is computed, if not provided.
Note that a population size \code{\link{N}} is not needed
for computing current probability information \code{\link{prob}},
but is needed for computing frequency information
\code{\link{freq}} from current probabilities \code{\link{prob}}.}

\item{by}{A character code specifying 1 or 2 perspective(s)
that split(s) the population into 2 subsets.
Specifying 1 perspective plots a frequency tree (single tree)
with 3 options:
  \enumerate{
  \item \code{"cd"}: by condition only;
  \item \code{"dc"}: by decision only;
  \item \code{"ac"}: by accuracy only.
  }
Specifying 2 perspectives plots a frequency prism (double tree)
with 6 options:
  \enumerate{
  \item \code{"cddc"}: by condition (cd) and by decision (dc) (default);
  \item \code{"cdac"}: by condition (cd) and by accuracy (ac);
  \item \code{"dccd"}: by decision (dc) and by condition (cd);
  \item \code{"dcac"}: by decision (dc) and by accuracy (ac);
  \item \code{"accd"}: by accuracy (ac) and by condition (cd);
  \item \code{"acdc"}: by accuracy (ac) and by decision (dc).
  }}

\item{area}{A character code specifying the shapes of the frequency boxes,
with 2 options:
  \enumerate{
  \item \code{"no"}: rectangular frequency boxes, not scaled (default);
  \item \code{"sq"}: frequency boxes are squares (scaled relative to N).
  }}

\item{scale}{Scale probabilities and corresponding area dimensions either by
exact probability or by (rounded or non-rounded) frequency, with 2 options:
  \enumerate{
  \item \code{"p"}: scale main area dimensions by exact probability (default);
  \item \code{"f"}: re-compute probabilities from (rounded or non-rounded) frequencies
  and scale main area dimensions by their frequency.
  }
 Note: \code{scale} setting matters for the display of probability values and for
 area plots with small population sizes \code{\link{N}} when \code{round = TRUE}.}

\item{round}{Boolean option specifying whether computed frequencies
are rounded to integers. Default: \code{round = TRUE}.}

\item{f_lbl}{Type of label for showing frequency values in 4 main areas,
with 6 options:
  \enumerate{
  \item \code{"def"}: abbreviated names and frequency values;
  \item \code{"abb"}: abbreviated frequency names only (as specified in code);
  \item \code{"nam"}: names only (as specified in \code{lbl_txt = txt});
  \item \code{"num"}: numeric frequency values only (default);
  \item \code{"namnum"}: names (as specified in \code{lbl_txt = txt}) and numeric values;
  \item \code{"no"}: no frequency labels (same for \code{f_lbl = NA} or \code{NULL}).
  }}

\item{f_lbl_sep}{Label separator for main frequencies
(used for \code{f_lbl = "def" OR "namnum"}).
Use \code{f_lbl_sep = ":\n"} to add a line break between name and numeric value.
Default: \code{f_lbl_sep = NA} (set to \code{" = "} or \code{":\n"} based on \code{f_lbl}).}

\item{f_lwd}{Line width of areas.
Default: \code{f_lwd = 0}.}

\item{p_lwd}{Line width of probability links.
Default: \code{p_lwd = 1}, but consider increasing when setting \code{p_scale = TRUE}.}

\item{p_scale}{Boolean option for scaling current widths of probability links
(as set by \code{p_lwd}) by the current probability values.
Default: \code{p_scale = FALSE}.}

\item{p_lbl}{Type of label for showing probability links and values,
with many options:
  \enumerate{
  \item \code{"abb"}: show links and abbreviated probability names;
  \item \code{"def"}: show links and abbreviated probability names and values;
  \item \code{"min"}: show links and minimum (prominent) probability names;
  \item \code{"mix"}: show links and prominent probability names and all values (default);
  \item \code{"nam"}: show links and probability names (as specified in code);
  \item \code{"num"}: show links and numeric probability values;
  \item \code{"namnum"}: show links with names and numeric probability values;
  \item \code{"no"}: show links with no labels (same for \code{p_lbl = NA} or \code{NULL}).
  }}

\item{arr_c}{Arrow code for symbols at ends of probability links
(as a numeric value \code{-3 <= arr_c <= +6}),
with the following options:
  \itemize{
  \item \code{-1} to \code{-3}: points at one/other/both end/s;
  \item \code{0}: no symbols;
  \item \code{+1} to \code{+3}: V-arrow at one/other/both end/s;
  \item \code{+4} to \code{+6}: T-arrow at one/other/both end/s.
}
Default: \code{arr_c = NA}, but adjusted by \code{area}.}

\item{joint_p}{Boolean options for showing links to joint probabilities
(i.e., diagonals from N in center to joint frequencies in 4 corners).
Default: \code{joint_p = TRUE}.}

\item{lbl_txt}{Default label set for text elements.
Default: \code{lbl_txt = \link{txt}}.}

\item{title_lbl}{Text label for current plot title.
Default: \code{title_lbl = txt$scen_lbl}.}

\item{cex_lbl}{Scaling factor for text labels (frequencies and headers).
Default: \code{cex_lbl = .90}.}

\item{cex_p_lbl}{Scaling factor for text labels (probabilities).
Default: \code{cex_p_lbl = cex_lbl - .05}.}

\item{col_pal}{Color palette.
Default: \code{col_pal = \link{pal}}.}

\item{mar_notes}{Boolean option for showing margin notes.
Default: \code{mar_notes = FALSE}.}

\item{...}{Other (graphical) parameters.}
}
\value{
Nothing (NULL).
}
\description{
\code{plot_fnet} plots a frequency net of
from a sufficient and valid set of 3 essential probabilities
(\code{\link{prev}}, and
\code{\link{sens}} or its complement \code{\link{mirt}}, and
\code{\link{spec}} or its complement \code{\link{fart}})
or existing frequency information \code{\link{freq}}
and a population size of \code{\link{N}} individuals.
}
\details{
\code{plot_fnet} shows frequencies as nodes and probabilities as links
(like trees and double trees generated by \code{\link{plot_prism}}),
but combines elements from 2x2 tables (see \code{\link{plot_tab}})
and tree diagrams.

Similar to other 2D-visualizations (e.g., ,
\code{\link{plot_area}}, \code{\link{plot_prism}} and
\code{\link{plot_tab}}), the
frequency net selects and combines two perspectives
(e.g., \code{by = "cddc"}).
However, the frequency net is similar to a 2x2 table insofar as
its perspectives (shown by arranging marginal frequencies in a
vertical vs. horizontal fashion) do not suggest an order
or dependency (in contrast to trees or mosaic plots).
Additionally, the frequency net allows showing
3 kinds of (marginal, conditional, and joint) probabilities.

See the article by Binder K, Krauss S and Wiesner P (2020).
A new visualization for probabilistic situations containing two binary events:
The frequency net. Frontiers in Psychology, 11, 750. doi: 10.3389/fpsyg.2020.00750
for analysis and details.
}
\examples{
# (1) Basics: ----
# A. Using global prob and freq values:
plot_fnet()  # default frequency net, same as:
# plot_fnet(by = "cddc", area = "no", scale = "p",
#            f_lbl = "num", f_lwd = 0, cex_lbl = .90,
#            p_lbl = "mix", arr_c = -2, cex_p_lbl = NA)

# B. Providing values:
plot_fnet(N = 10000, prev = .02, sens = .8, spec = .9)  # Binder et al. (2020, Fig. 3)

# Variants:
plot_fnet(N = 10000, prev = .02, sens = .8, spec = .9, by = "cdac")
plot_fnet(N = 10000, prev = .02, sens = .8, spec = .9, by = "dccd")
# plot_fnet(N = 10000, prev = .02, sens = .8, spec = .9, by = "dcac")
# plot_fnet(N = 10000, prev = .02, sens = .8, spec = .9, by = "accd")
# plot_fnet(N = 10000, prev = .02, sens = .8, spec = .9, by = "acdc")

# Trees (only 1 dimension):
plot_fnet(N = 10000, prev = .02, sens = .8, spec = .9, by = "cd")
# plot_fnet(N = 10000, prev = .02, sens = .8, spec = .9, by = "dc")
# plot_fnet(N = 10000, prev = .02, sens = .8, spec = .9, by = "ac")

# Area and margin notes:
plot_fnet(N = 10, prev = 1/4, sens = 3/5, spec = 2/5, area = "sq", mar_notes = TRUE)


# (2) Use case (highlight horizontal vs. vertical perspectives: ----
# Define scenario:
mammo <- riskyr(N = 10000, prev = .01, sens = .80, fart = .096,
                scen_lbl = "Mammography screening", N_lbl = "Women",
                cond_lbl = "Breast cancer", dec_lbl = "Test result",
                cond_true_lbl = "Cancer (C+)", cond_false_lbl = "no Cancer (C-)",
                dec_pos_lbl = "positive (T+)", dec_neg_lbl = "negative (T-)",
                hi_lbl = "C+ and T+", mi_lbl = "C+ and T-",
                fa_lbl = "C- and T+", cr_lbl = "C- and T-")
# Colors:
my_non <- "grey95"
my_red <- "orange1"
my_blu <- "skyblue1"

# A. Emphasize condition perspective (rows):
my_col_1 <- init_pal(N_col = my_non,
                     cond_true_col = my_blu, cond_false_col = my_red,
                     dec_pos_col = my_non, dec_neg_col = my_non,
                     hi_col = my_blu, mi_col = my_blu,
                     fa_col = my_red, cr_col = my_red)
plot(mammo, type = "fnet", col_pal = my_col_1,
     f_lbl = "namnum", f_lwd = 2, p_lbl = "no", arr_c = 0)

# B. Emphasize decision perspective (columns):
my_col_2 <- init_pal(N_col = my_non,
                     cond_true_col = my_non, cond_false_col = my_non,
                     dec_pos_col = my_red, dec_neg_col = my_blu,
                     hi_col = my_red, mi_col = my_blu,
                     fa_col = my_red, cr_col = my_blu)
plot(mammo, type = "fnet", col_pal = my_col_2,
     f_lbl = "namnum", f_lwd = 2, p_lbl = "no", arr_c = 0)


# (3) Custom color and text settings: ----
plot_fnet(col_pal = pal_bw, f_lwd = .5, p_lwd = .5, lty = 2, # custom fbox color, prob links,
          font = 3, cex_p_lbl = .75)                         # and text labels

plot_fnet(N = 7, prev = 1/2, sens = 3/5, spec = 4/5, round = FALSE,
          by = "cdac", lbl_txt = txt_org, f_lbl = "namnum", f_lbl_sep = ":\n",
          f_lwd = 1, col_pal = pal_rgb)  # custom colors

# plot_fnet(N = 5, prev = 1/2, sens = .8, spec = .5, scale = "p",   # Note scale!
#           by = "cddc", area = "hr", col_pal = pal_bw, f_lwd = 1)  # custom colors

plot_fnet(N = 3, prev = .50, sens = .50, spec = .50, scale = "p",              # Note scale!
          area = "sq", lbl_txt = txt_org, f_lbl = "namnum", f_lbl_sep = ":\n", # custom text
          col_pal = pal_kn, f_lwd = .5)                                        # custom colors

# (4) Other options: ----
plot_fnet(N = 4, prev = .2, sens = .7, spec = .8,
          area = "sq", scale = "p")  # areas scaled by prob (matters for small N)
# plot_fnet(N = 4, prev = .2, sens = .7, spec = .8,
#           area = "sq", scale = "f")  # areas scaled by (rounded or non-rounded) freq

## Frequency boxes (f_lbl):
# plot_fnet(f_lbl = NA)       # no freq labels
# plot_fnet(f_lbl = "abb")    # abbreviated freq names (variable names)
plot_fnet(f_lbl = "nam")      # only freq names
plot_fnet(f_lbl = "num")      # only numeric freq values (default)
# plot_fnet(f_lbl = "namnum") # names and numeric freq values
plot_fnet(f_lbl = "namnum", cex_lbl = .75)  # smaller freq labels
# plot_fnet(f_lbl = "def")    # informative default: short name and numeric value (abb = num)

# f_lwd:
# plot_fnet(f_lwd =  1)  # basic lines
# plot_fnet(f_lwd =  0)  # no lines (default), set to tiny_lwd = .001, lty = 0 (same if NA/NULL)
# plot_fnet(f_lwd = .5)  # thinner lines
plot_fnet(f_lwd =  3)    # thicker lines

## Probability links (p_lbl, p_lwd, p_scale):
# plot_fnet(p_lbl = NA)       # no prob labels (NA/NULL/"none")
plot_fnet(p_lbl = "mix")      # abbreviated names with numeric values (abb = num)
# plot_fnet(p_lbl = "min")    # minimal names (of key probabilities)
# plot_fnet(p_lbl = "nam")    # only prob names
plot_fnet(p_lbl = "num")      # only numeric prob values
# plot_fnet(p_lbl = "namnum") # names and numeric prob values

plot_fnet(p_lwd = 6, p_scale = TRUE)
plot_fnet(area = "sq", f_lbl = "num", p_lbl = NA, col_pal = pal_bw, p_lwd = 6, p_scale = TRUE)

# arr_c:
# plot_fnet(arr_c =  0)  # acc_c = 0: no arrows
# plot_fnet(arr_c = -3)  # arr_c = -1 to -3: points at both ends
# plot_fnet(arr_c = -2)  # point at far end
plot_fnet(arr_c = +2)    # crr_c = 1-3: V-shape arrows at far end

plot_fnet(by = "cd", joint_p = FALSE)      # tree without joint probability links
# plot_fnet(by = "cddc", joint_p = FALSE)  # fnet ...

## Plain plot versions:
plot_fnet(area = "no", f_lbl = "def", p_lbl = "num", col_pal = pal_mod, f_lwd = 1,
          title_lbl = "", mar_notes = FALSE)  # remove titles and margin notes
plot_fnet(area = "no", f_lbl = "nam", p_lbl = "min", col_pal = pal_rgb)

plot_fnet(area = "sq", f_lbl = "nam", p_lbl = "num", col_pal = pal_rgb)
# plot_fnet(area = "sq", f_lbl = "def", f_lbl_sep = ":\n", p_lbl = NA, f_lwd = 1, col_pal = pal_kn)

## Suggested combinations:
# plot_fnet(f_lbl = "nam", p_lbl = "mix")  # basic plot
plot_fnet(f_lbl = "namnum", p_lbl = "num", cex_lbl = .80, cex_p_lbl = .75)
# plot_fnet(area = "no", f_lbl = "def", p_lbl = "abb",           # def/abb labels
#           f_lwd = .8, p_lwd = .8, lty = 2, col_pal = pal_bwp)  # black-&-white

# plot_fnet(area = "sq", f_lbl = "nam", p_lbl = "abb", lbl_txt = txt_TF, col_pal = pal_bw)
plot_fnet(area = "sq", f_lbl = "num", p_lbl = "num", f_lwd = 1, col_pal = pal_rgb)
plot_fnet(area = "sq", f_lbl = "nam", p_lbl = "num", f_lwd = .5, col_pal = pal_rgb)

}
\seealso{
\code{\link{plot_prism}} for plotting prism plot (double tree);
\code{\link{plot_area}} for plotting mosaic plot (scaling area dimensions);
\code{\link{plot_bar}} for plotting frequencies as vertical bars;
\code{\link{plot_tab}} for plotting table (without scaling area dimensions);
\code{\link{pal}} contains current color settings;
\code{\link{txt}} contains current text settings.

Other visualization functions: 
\code{\link{plot.riskyr}()},
\code{\link{plot_area}()},
\code{\link{plot_bar}()},
\code{\link{plot_curve}()},
\code{\link{plot_icons}()},
\code{\link{plot_mosaic}()},
\code{\link{plot_plane}()},
\code{\link{plot_prism}()},
\code{\link{plot_tab}()},
\code{\link{plot_tree}()}
}
\concept{visualization functions}
