% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apps_of_direction.R
\name{upstreammat}
\alias{upstreammat}
\title{Upstream Distance Matrix}
\usage{
upstreammat(seg, vert, rivers, logical = NULL, ID = NULL,
  flowconnected = FALSE, net = FALSE, stopiferror = TRUE,
  algorithm = NULL)
}
\arguments{
\item{seg}{A vector of river locations (segment component).}

\item{vert}{A vector of river locations (vertex component).}

\item{rivers}{The river network object to use.}

\item{logical}{A boolean vector that can be used for subsetting - if used,
riverdirectionseq() will only return pairwise distances in which a
specified condition is met.}

\item{ID}{a vector of observation IDs for aid in interpreting the output
table}

\item{flowconnected}{If \code{TRUE}, only returns distance if the input segments are flow-connected.  Defaults to \code{FALSE}.}

\item{net}{Whether to calculate net upstream distance (net=TRUE) or total
distance (net=FALSE, default).  See \link{upstream}.}

\item{stopiferror}{Whether or not to exit with an error if a route cannot be
found.  If this is set to \code{FALSE} and a route cannot be found,
the function will return \code{NA} in the appropriate entry.  Defaults to \code{TRUE}.  See \link{detectroute}.}

\item{algorithm}{Which route detection algorithm to use (\code{"Dijkstra"},
\code{"sequential"}, or \code{"segroutes"}).  If left as \code{NULL} (the
default), the function will automatically make a selection.  See
\link{detectroute} for more details.}
}
\value{
A matrix of upstream distances (numeric) with rows and columns
  labeled by corresponding values of \code{ID}.  See \link{upstream} for additional information.
}
\description{
Returns a matrix of upstream distance between every point and
  every other point of given river locations (segment and vertex), or of a
  subset.  The mouth (lowest point) segment and vertex must be specified
  (see \link{setmouth}).
}
\note{
Building routes from the river mouth to each river network segment and/or distance lookup tables will
  greatly reduce computation time (see \link{buildsegroutes}).
}
\examples{
data(Gulk, fakefish)

# Mouth must be specified
Gulk$mouth$mouth.seg <- 1
Gulk$mouth$mouth.vert <- 1

logi1 <- (fakefish$flight.date==as.Date("2015-11-25"))

upstreammat(seg=fakefish$seg, vert=fakefish$vert, rivers=Gulk, logical=logi1)
}
\author{
Matt Tyers
}
\seealso{
\link{upstream}
}

