% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{compile4gpu}
\alias{compile4gpu}
\title{Enable compilation of GPU-compatible user-defined operators if possible}
\usage{
compile4gpu()
}
\value{
None
}
\description{
Set up \code{rkeops} compile options to compile user-defined operators that run
on GPU. If CUDA is not available, user-defined operators will
still be compiled without GPU support.
}
\details{
Compiling GPU-compatible user-defined operators requires CUDA and \code{nvcc}
(Nvidia compiler). If not available, user-defined operators will only be
CPU-compatible.

\strong{Note:} Default behavior is to compile GPU-compatible operators thus, if
you do not modify \code{rkeops} options, it is optional to use the function
\code{compile4gpu}.

When a GPU-compatible operator is compiled, you should call
\code{\link[rkeops:use_gpu]{rkeops::use_gpu()}} to ensure that computation will be run on GPU
(difference between compilation and runtime options). GPU-compatible
operators can run on CPU.
}
\examples{
library(rkeops)
compile4gpu()
}
\seealso{
\code{\link[rkeops:compile4cpu]{rkeops::compile4cpu()}}, \code{\link[rkeops:use_gpu]{rkeops::use_gpu()}},
}
\author{
Ghislain Durif
}
