% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.R
\name{RQ.Kernel}
\alias{RQ.Kernel}
\title{Rational Quadratic (RQ) Kernel}
\usage{
RQ.Kernel(lengthscale, alpha = 1)
}
\arguments{
\item{lengthscale}{a vector for the positive length scale parameters}

\item{alpha}{a positive scalar for the scale mixture parameter that controls the relative weighting of large-scale and small-scale variations}
}
\value{
A Rational Quadratic (RQ) Kernel Class Object.
}
\description{
This function specifies the Rational Quadratic (RQ) kernel.
}
\details{
The Rational Quadratic (RQ) kernel is given by 
\deqn{k(r;\alpha)=\left(1+\frac{r^2}{2\alpha}\right)^{-\alpha},}{k(r;alpha) = (1+[r^2/(2*alpha)])^{-alpha},}
where \eqn{\alpha}{alpha} is the scale mixture parameter and 
\deqn{r(x,x^{\prime})=\sqrt{\sum_{i=1}^{p}\left(\frac{x_{i}-x_{i}^{\prime}}{l_{i}}\right)^2}}{r(x,x') = sqrt(sum_{i=1}^{p} [(x_i - x'_i) / l_i]^2)} 
is the euclidean distance between \eqn{x}{x} and \eqn{x^{\prime}}{x'} weighted by
the length scale parameters \eqn{l_{i}}{l_i}'s.
As \eqn{\alpha\to\infty}{alpha goes to infinity}, it converges to the \link{Gaussian.Kernel}.
}
\examples{
n <- 5
p <- 3
X <- matrix(rnorm(n*p), ncol=p)
lengthscale <- c(1:p)

# approach 1
kernel <- RQ.Kernel(lengthscale, alpha=1)
Evaluate.Kernel(kernel, X)

# approach 2
kernel <- Get.Kernel(lengthscale, type="RQ", parameters=list(alpha=1))
Evaluate.Kernel(kernel, X) 

}
\references{
Duvenaud, D. (2014). \emph{The kernel cookbook: Advice on covariance functions}.

Rasmussen, C. E. & Williams, C. K. (2006). \emph{Gaussian Processes for Machine Learning}. The MIT Press.
}
\seealso{
\link{MultiplicativeRQ.Kernel}, \link{Get.Kernel}, \link{Evaluate.Kernel}.
}
\author{
Chaofan Huang and V. Roshan Joseph
}
