% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env.R
\name{env_depth}
\alias{env_depth}
\title{Depth of an environment chain}
\usage{
env_depth(env)
}
\arguments{
\item{env}{An environment or an object bundling an environment,
e.g. a formula, \link{quosure} or \link[=is_closure]{closure}.}
}
\value{
An integer.
}
\description{
This function returns the number of environments between \code{env} and
the \link[=empty_env]{empty environment}, including \code{env}. The depth of
\code{env} is also the number of parents of \code{env} (since the empty
environment counts as a parent).
}
\examples{
env_depth(empty_env())
env_depth(pkg_env("rlang"))
}
\seealso{
The section on inheritance in \code{\link[=env]{env()}} documentation.
}
