% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_folder.R
\name{convert_folder}
\alias{convert_folder}
\title{Converts files in folder to CSS files}
\usage{
convert_folder(input_folder, output_folder = tempdir(),
  recursive = FALSE, pattern = "*.less$")
}
\arguments{
\item{input_folder}{Path to files to be converted}

\item{output_folder}{Output path where converted files should be placed
Files are placed to \code{tempdir} by default}

\item{recursive}{Boolean value used when searching for filed to be converted}

\item{pattern}{Pattern which files need to match to be converted}
}
\value{
List of file paths to converted files is returned
}
\description{
Function goes through folder specified in \emph{input_folder} and finds files
matching the \emph{pattern}. If \emph{recursive} is set to TRUE, scanner
are also subdirectories of the \emph{input_folder}. Matching files are
converted using \code{\link{convert_file}} function.
}
\examples{
path_to_less_files <- system.file("extdata", package="rless")

convert_folder(path_to_less_files)
convert_folder(path_to_less_files, tempdir())
convert_folder(path_to_less_files, recursive = TRUE)
convert_folder(path_to_less_files, pattern = '*.css$')

}
