% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_for_estimates.r
\name{sf}
\alias{sf}
\title{Statistic V}
\usage{
sf(path, f, k, r, H, freq, ...)
}
\arguments{
\item{path}{sample path for which the statistic is to be calculated.}

\item{f}{function applied to high order increments.}

\item{k}{order of the increments.}

\item{r}{step of high order increments.}

\item{H}{Hurst parameter.}

\item{freq}{frequency.}

\item{...}{parameters to pass to function f}
}
\description{
Statistic of the form
\deqn{V_{\textnormal{high}}(f; k,r)_n:=\frac{1}{n}\sum_{i=rk}^n f\left( n^H \Delta_{i,k}^{n,r} X \right),  }
\deqn{V_{\textnormal{low}}(f; k,r)_n :=\frac{1}{n}\sum_{i=rk}^n f\left( \Delta_{i,k}^{r} X \right)}
}
\details{
Hurst parameter is required only in high frequency case. In the low frequency, there is no need to assign H a value because it will not be evaluated.
}
\examples{
m<-45; M<-60; N<-2^10-M
alpha<-1.8; H<-0.8; sigma<-0.3
freq='L'
r=1; k=2; p=0.4
S<-(1:20)*100

path_lfsm<-function(...){

    List<-path(...)
    List$lfsm

}

Pths<-lapply(X=S,FUN=path_lfsm,
             m=m, M=M, alpha=alpha, sigma=sigma, H=H,
             freq=freq, disable_X = FALSE,
             levy_increments = NULL, seed = NA)

f_phi<-function(t,x) cos(t*x)
f_pow<-function(x,p) (abs(x))^p

V_cos<-sapply(Pths,FUN=sf,f=f_phi,k=k,r=r,H=H,freq=freq,t=1)
ex<-exp(-(abs(sigma*Norm_alpha(h_kr,alpha=alpha,k=k,r=r,H=H,l=0)$result)^alpha))

 # Illustration of the law of large numbers for phi:
plot(y=V_cos, x=S, ylim = c(0,max(V_cos)+0.1))
abline(h=ex, col='brown')

# Illustration of the law of large numbers for power functions:
Mpk<-m_pk(k=k, p=p, alpha=alpha, H=H, sigma=sigma)

sf_mod<-function(Xpath,...) {

    Path<-unlist(Xpath)
    sf(path=Path,...)
}

V_pow<-sapply(Pths,FUN=sf_mod,f=f_pow,k=k,r=r,H=H,freq=freq,p=p)
plot(y=V_pow, x=S, ylim = c(0,max(V_pow)+0.1))
abline(h=Mpk, col='brown')


}
\references{
\insertRef{MOP18}{rlfsm}
}
\seealso{
\code{\link{phi}} computes V statistic with f(.)=cos(t.)
}
