% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{calcDatasetSpecificity}
\alias{calcDatasetSpecificity}
\title{Calculate a dataset-specificity score for each factor}
\usage{
calcDatasetSpecificity(
  object,
  dataset1 = NULL,
  dataset2 = NULL,
  do.plot = TRUE
)
}
\arguments{
\item{object}{\code{liger} object. Should run optimizeALS before calling.}

\item{dataset1}{Name of first dataset (by default takes first two datasets for dataset1 and 2)}

\item{dataset2}{Name of second dataset}

\item{do.plot}{Display barplot of dataset specificity scores (by factor) (default TRUE).}
}
\value{
List containing three elements. First two elements are the norm of each metagene factor
for each dataset. Last element is the vector of dataset specificity scores.
}
\description{
This score represents the relative magnitude of the dataset-specific components of each factor's
gene loadings compared to the shared components for two datasets. First, for each dataset we
calculate the norm of the sum of each factor's shared loadings (W) and dataset-specific loadings
(V). We then determine the ratio of these two values and subtract from 1... TODO: finish
description.
}
\examples{
\dontrun{
# ligerex (liger object), factorization complete
# generate H.norm by quantile normalizig factor loadings
ligerex <- quantile_norm(ligerex)
dataset_spec <- calcDatasetSpecificity(ligerex, do.plot = F)
}
}
