% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{optimizeNewK}
\alias{optimizeNewK}
\title{Perform factorization for new value of k}
\usage{
optimizeNewK(
  object,
  k.new,
  lambda = NULL,
  thresh = 1e-04,
  max.iters = 100,
  rand.seed = 1,
  verbose = TRUE
)
}
\arguments{
\item{object}{\code{liger} object. Should call optimizeALS before calling.}

\item{k.new}{Inner dimension of factorization (number of factors)}

\item{lambda}{Regularization parameter. By default, this will use the lambda last used with
optimizeALS.}

\item{thresh}{Convergence threshold. Convergence occurs when |obj0-obj|/(mean(obj0,obj)) < thresh
(default 1e-4).}

\item{max.iters}{Maximum number of block coordinate descent iterations to perform (default 100).}

\item{rand.seed}{Random seed to set. Only relevant if k.new > k. (default 1)}

\item{verbose}{Print progress bar/messages (TRUE by default)}
}
\value{
\code{liger} object with H, W, and V slots reset.
}
\description{
This uses an efficient strategy for updating that takes advantage of the information in the
existing factorization. It is most recommended for values of k smaller than current value,
where it is more likely to speed up the factorization.
}
\examples{
\dontrun{
# decide to run with k = 15 instead (keeping old lambda the same)
ligerex <- optimizeNewK(ligerex, k.new = 15)
}
}
