% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ligerDataset-methods.R
\name{modalOf}
\alias{modalOf}
\title{Return preset modality of a ligerDataset object or that of all datasets in a
liger object}
\usage{
modalOf(object)
}
\arguments{
\item{object}{a \linkS4class{ligerDataset} object or a \linkS4class{liger}
object}
}
\value{
A single character of modality setting value for
\linkS4class{ligerDataset} \code{object}, or a named vector for
\linkS4class{liger} object, where the names are dataset names.
}
\description{
Return preset modality of a ligerDataset object or that of all datasets in a
liger object
}
\examples{
modalOf(pbmc)
ctrl <- dataset(pbmc, "ctrl")
modalOf(ctrl)
ctrl.atac <- as.ligerDataset(ctrl, modal = "atac")
modalOf(ctrl.atac)
}
