% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paginate_listing.R
\name{paginate_listing}
\alias{paginate_listing}
\alias{pag_listing_indices}
\title{Paginate listings}
\usage{
paginate_listing(
  lsting,
  page_type = "letter",
  font_family = "Courier",
  font_size = 12,
  lineheight = 1,
  landscape = FALSE,
  pg_width = NULL,
  pg_height = NULL,
  margins = c(top = 0.5, bottom = 0.5, left = 0.75, right = 0.75),
  lpp,
  cpp,
  colwidths = propose_column_widths(lsting),
  tf_wrap = FALSE,
  max_width = NULL,
  verbose = FALSE
)

pag_listing_indices(
  lsting,
  lpp = 15,
  colwidths = NULL,
  max_width = NULL,
  verbose = FALSE
)
}
\arguments{
\item{lsting}{listing_df. The listing to paginate.}

\item{page_type}{character(1).   Name   of  a  page  type.   See
\code{page_types}.   Ignored when  \code{pg_width} and  \code{pg_height}
are set directly.}

\item{font_family}{character(1). Name of a font family. An error
will be thrown if the family named is not monospaced. Defaults
to Courier.}

\item{font_size}{numeric(1). Font size, defaults to 12.}

\item{lineheight}{numeric(1). Line height, defaults to 1.}

\item{landscape}{logical(1). Should the  dimensions of \code{page_type}
be inverted  for landscape?  Defaults to  \code{FALSE}, ignored when
\code{pg_width} and \code{pg_height} are set directly.}

\item{pg_width}{numeric(1). Page width in inches.}

\item{pg_height}{numeric(1). Page height in inches.}

\item{margins}{numeric(4). Named numeric vector containing \code{'top'},
\code{'bottom'}, \code{'left'}, and \code{'right'} margins in inches. Defaults
to \code{.5} inches for both vertical margins and \code{.75} for both
horizontal margins.}

\item{lpp}{numeric(1) or NULL. Number of row lines (not counting titles and
footers) to have per page. Standard is \code{70} while \code{NULL} disables vertical
pagination.}

\item{cpp}{numeric(1) or NULL. Width (in characters) of the pages for
horizontal pagination. \code{NULL} (the default) indicates no horizontal
pagination should be done.}

\item{colwidths}{numeric vector.  Column widths (in characters) for
use with vertical pagination.}

\item{tf_wrap}{logical(1). Should  the texts for  title, subtitle,
and footnotes be wrapped?}

\item{max_width}{integer(1), character(1) or NULL. Width that title
and   footer   (including   footnotes)  materials   should   be
word-wrapped to. If NULL, it is  set to the current print width
of the  session (\code{getOption("width")}). If set to \code{"auto"},
the width of the table (plus any table inset) is used. Ignored
completely if \code{tf_wrap} is \code{FALSE}.}

\item{verbose}{logical(1). Should additional informative messages about the search for
pagination breaks be shown. Defaults to \code{FALSE}.}
}
\value{
A list of listings' objects that are meant to be on separated pages.
For \code{pag_tt_indices} a list of paginated-groups of row-indices of \code{lsting}.

for \code{paginate_listing} a list containing separate
\code{listing_df} objects for each page, for \code{pag_listing_indices},
a list of indices in the direction being paginated corresponding
to the individual pages in that dimension.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Pagination of a listing. This can be vertical for long listings with many
rows or horizontal if there are many columns.
}
\examples{
dat <- ex_adae
lsting <- as_listing(dat[1:25, ], disp_cols = c("USUBJID", "AESOC", "RACE", "AETOXGR", "BMRKR1"))

mat <- matrix_form(lsting)

cat(toString(mat))

paginate_listing(lsting, lpp = 10)

paginate_listing(lsting, cpp = 100, lpp = 40)

paginate_listing(lsting, cpp = 80, lpp = 40, verbose = TRUE)
}
